/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.ThreadSafe;
import io.trino.annotation.NotThreadSafe;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;

@NotThreadSafe
class OperationTimer {
    private static final ThreadMXBean THREAD_MX_BEAN = ManagementFactory.getThreadMXBean();
    private final boolean trackOverallCpuTime;
    private final boolean trackOperationCpuTime;
    private final long wallStart;
    private final long cpuStart;
    private long intervalWallStart;
    private long intervalCpuStart;
    private boolean finished;

    OperationTimer(boolean trackOverallCpuTime) {
        this(trackOverallCpuTime, false);
    }

    OperationTimer(boolean trackOverallCpuTime, boolean trackOperationCpuTime) {
        this.trackOverallCpuTime = trackOverallCpuTime;
        this.trackOperationCpuTime = trackOperationCpuTime;
        Preconditions.checkArgument((trackOverallCpuTime || !trackOperationCpuTime ? 1 : 0) != 0, (Object)"tracking operation cpu time without tracking overall cpu time is not supported");
        this.wallStart = System.nanoTime();
        this.cpuStart = trackOverallCpuTime ? OperationTimer.currentThreadCpuTime() : 0L;
        this.intervalWallStart = this.wallStart;
        this.intervalCpuStart = this.cpuStart;
    }

    void recordOperationComplete(OperationTiming operationTiming) {
        Objects.requireNonNull(operationTiming, "operationTiming is null");
        Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"timer is finished");
        long intervalCpuEnd = this.trackOperationCpuTime ? OperationTimer.currentThreadCpuTime() : 0L;
        long intervalWallEnd = System.nanoTime();
        long operationWallNanos = OperationTimer.nanosBetween(this.intervalWallStart, intervalWallEnd);
        long operationCpuNanos = this.trackOperationCpuTime ? OperationTimer.nanosBetween(this.intervalCpuStart, intervalCpuEnd) : 0L;
        operationTiming.record(operationWallNanos, operationCpuNanos);
        this.intervalWallStart = intervalWallEnd;
        this.intervalCpuStart = intervalCpuEnd;
    }

    void end(OperationTiming overallTiming) {
        Objects.requireNonNull(overallTiming, "overallTiming is null");
        Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"timer is finished");
        this.finished = true;
        long cpuEnd = this.trackOverallCpuTime ? OperationTimer.currentThreadCpuTime() : 0L;
        long wallEnd = System.nanoTime();
        overallTiming.record(OperationTimer.nanosBetween(this.wallStart, wallEnd), OperationTimer.nanosBetween(this.cpuStart, cpuEnd));
    }

    private static long currentThreadCpuTime() {
        return THREAD_MX_BEAN.getCurrentThreadCpuTime();
    }

    private static long nanosBetween(long start, long end) {
        return Math.max(0L, end - start);
    }

    @ThreadSafe
    static class OperationTiming {
        private final AtomicLong calls = new AtomicLong();
        private final AtomicLong wallNanos = new AtomicLong();
        private final AtomicLong cpuNanos = new AtomicLong();

        OperationTiming() {
        }

        long getCalls() {
            return this.calls.get();
        }

        long getWallNanos() {
            return this.wallNanos.get();
        }

        long getCpuNanos() {
            return this.cpuNanos.get();
        }

        void record(long wallNanos, long cpuNanos) {
            this.calls.incrementAndGet();
            this.wallNanos.addAndGet(wallNanos);
            this.cpuNanos.addAndGet(cpuNanos);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("calls", (Object)this.calls).add("wallNanos", (Object)this.wallNanos).add("cpuNanos", (Object)this.cpuNanos).toString();
        }
    }
}

