/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import io.trino.operator.SpoolingController;

public class OperatorSpoolingController
implements SpoolingController {
    private long currentSpooledSegmentTarget;
    private final long maximumSpooledSegmentTarget;
    private final SpoolingController.ActionMetrics spooled = new SpoolingController.ActionMetrics();
    private final SpoolingController.ActionMetrics buffered = new SpoolingController.ActionMetrics();
    private SpoolingController.Mode currentMode = SpoolingController.Mode.BUFFER;

    public OperatorSpoolingController(long initialSpooledSegmentTarget, long maximumSpooledSegmentTarget) {
        this.currentSpooledSegmentTarget = initialSpooledSegmentTarget;
        this.maximumSpooledSegmentTarget = maximumSpooledSegmentTarget;
    }

    @Override
    public SpoolingController.Mode nextMode(int positions, long size) {
        switch (this.currentMode) {
            default: {
                throw new MatchException(null, null);
            }
            case INLINE: {
                throw new IllegalStateException("OperatorSpoolingController does not handle INLINE mode");
            }
            case SPOOL: 
            case BUFFER: 
        }
        SpoolingController.MetricSnapshot snapshot = this.buffered.snapshot();
        return snapshot.size() + size >= this.currentSpooledSegmentTarget ? this.execute(SpoolingController.Mode.SPOOL, positions, size) : this.execute(SpoolingController.Mode.BUFFER, positions, size);
    }

    @Override
    public SpoolingController.Mode execute(SpoolingController.Mode mode, long positions, long size) {
        this.currentMode = mode;
        switch (mode) {
            case BUFFER: {
                this.buffered.recordPage(positions, size);
                break;
            }
            case SPOOL: {
                SpoolingController.MetricSnapshot snapshot = this.buffered.snapshot();
                this.buffered.reset();
                this.spooled.recordPage(positions + snapshot.positions(), size + snapshot.size());
                this.currentSpooledSegmentTarget = Math.min(this.currentSpooledSegmentTarget * 2L, this.maximumSpooledSegmentTarget);
                break;
            }
            case INLINE: {
                throw new IllegalStateException("OperatorSpoolingController does not handle INLINE mode");
            }
        }
        return this.currentMode;
    }

    @Override
    public SpoolingController.MetricSnapshot getMetrics(SpoolingController.Mode mode) {
        return switch (mode) {
            default -> throw new MatchException(null, null);
            case SpoolingController.Mode.BUFFER -> this.buffered.snapshot();
            case SpoolingController.Mode.SPOOL -> this.spooled.snapshot();
            case SpoolingController.Mode.INLINE -> throw new IllegalStateException("OperatorSpoolingController does not handle INLINE mode");
        };
    }

    public long getCurrentSpooledSegmentTarget() {
        return this.currentSpooledSegmentTarget;
    }
}

