/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.execution.DistributionSnapshot;
import io.trino.operator.BlockedReason;
import io.trino.operator.OperatorInfo;
import io.trino.spi.Mergeable;
import io.trino.spi.metrics.Metrics;
import io.trino.sql.planner.plan.PlanNodeId;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

@Immutable
public class OperatorStats {
    private final int stageId;
    private final int pipelineId;
    private final int operatorId;
    private final PlanNodeId planNodeId;
    private final String operatorType;
    private final long totalDrivers;
    private final long addInputCalls;
    private final Duration addInputWall;
    private final Duration addInputCpu;
    private final DataSize physicalInputDataSize;
    private final long physicalInputPositions;
    private final Duration physicalInputReadTime;
    private final DataSize internalNetworkInputDataSize;
    private final long internalNetworkInputPositions;
    private final DataSize rawInputDataSize;
    private final DataSize inputDataSize;
    private final long inputPositions;
    private final double sumSquaredInputPositions;
    private final long getOutputCalls;
    private final Duration getOutputWall;
    private final Duration getOutputCpu;
    private final DataSize outputDataSize;
    private final long outputPositions;
    private final long dynamicFilterSplitsProcessed;
    private final Metrics metrics;
    private final Metrics connectorMetrics;
    private final Metrics pipelineMetrics;
    private final DataSize physicalWrittenDataSize;
    private final Duration blockedWall;
    private final long finishCalls;
    private final Duration finishWall;
    private final Duration finishCpu;
    private final DataSize userMemoryReservation;
    private final DataSize revocableMemoryReservation;
    private final DataSize peakUserMemoryReservation;
    private final DataSize peakRevocableMemoryReservation;
    private final DataSize peakTotalMemoryReservation;
    private final DataSize spilledDataSize;
    private final Optional<BlockedReason> blockedReason;
    @Nullable
    private final OperatorInfo info;

    @JsonCreator
    public OperatorStats(@JsonProperty(value="stageId") int stageId, @JsonProperty(value="pipelineId") int pipelineId, @JsonProperty(value="operatorId") int operatorId, @JsonProperty(value="planNodeId") PlanNodeId planNodeId, @JsonProperty(value="operatorType") String operatorType, @JsonProperty(value="totalDrivers") long totalDrivers, @JsonProperty(value="addInputCalls") long addInputCalls, @JsonProperty(value="addInputWall") Duration addInputWall, @JsonProperty(value="addInputCpu") Duration addInputCpu, @JsonProperty(value="physicalInputDataSize") DataSize physicalInputDataSize, @JsonProperty(value="physicalInputPositions") long physicalInputPositions, @JsonProperty(value="physicalInputReadTime") Duration physicalInputReadTime, @JsonProperty(value="internalNetworkInputDataSize") DataSize internalNetworkInputDataSize, @JsonProperty(value="internalNetworkInputPositions") long internalNetworkInputPositions, @JsonProperty(value="rawInputDataSize") DataSize rawInputDataSize, @JsonProperty(value="inputDataSize") DataSize inputDataSize, @JsonProperty(value="inputPositions") long inputPositions, @JsonProperty(value="sumSquaredInputPositions") double sumSquaredInputPositions, @JsonProperty(value="getOutputCalls") long getOutputCalls, @JsonProperty(value="getOutputWall") Duration getOutputWall, @JsonProperty(value="getOutputCpu") Duration getOutputCpu, @JsonProperty(value="outputDataSize") DataSize outputDataSize, @JsonProperty(value="outputPositions") long outputPositions, @JsonProperty(value="dynamicFilterSplitsProcessed") long dynamicFilterSplitsProcessed, @JsonProperty(value="metrics") Metrics metrics, @JsonProperty(value="connectorMetrics") Metrics connectorMetrics, @JsonProperty(value="pipelineMetrics") Metrics pipelineMetrics, @JsonProperty(value="physicalWrittenDataSize") DataSize physicalWrittenDataSize, @JsonProperty(value="blockedWall") Duration blockedWall, @JsonProperty(value="finishCalls") long finishCalls, @JsonProperty(value="finishWall") Duration finishWall, @JsonProperty(value="finishCpu") Duration finishCpu, @JsonProperty(value="userMemoryReservation") DataSize userMemoryReservation, @JsonProperty(value="revocableMemoryReservation") DataSize revocableMemoryReservation, @JsonProperty(value="peakUserMemoryReservation") DataSize peakUserMemoryReservation, @JsonProperty(value="peakRevocableMemoryReservation") DataSize peakRevocableMemoryReservation, @JsonProperty(value="peakTotalMemoryReservation") DataSize peakTotalMemoryReservation, @JsonProperty(value="spilledDataSize") DataSize spilledDataSize, @JsonProperty(value="blockedReason") Optional<BlockedReason> blockedReason, @Nullable @JsonProperty(value="info") OperatorInfo info) {
        this.stageId = stageId;
        this.pipelineId = pipelineId;
        Preconditions.checkArgument((operatorId >= 0 ? 1 : 0) != 0, (Object)"operatorId is negative");
        this.operatorId = operatorId;
        this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
        this.operatorType = Objects.requireNonNull(operatorType, "operatorType is null");
        this.totalDrivers = totalDrivers;
        this.addInputCalls = addInputCalls;
        this.addInputWall = Objects.requireNonNull(addInputWall, "addInputWall is null");
        this.addInputCpu = Objects.requireNonNull(addInputCpu, "addInputCpu is null");
        this.physicalInputDataSize = Objects.requireNonNull(physicalInputDataSize, "physicalInputDataSize is null");
        this.physicalInputPositions = physicalInputPositions;
        this.physicalInputReadTime = Objects.requireNonNull(physicalInputReadTime, "physicalInputReadTime is null");
        this.internalNetworkInputDataSize = Objects.requireNonNull(internalNetworkInputDataSize, "internalNetworkInputDataSize is null");
        this.internalNetworkInputPositions = internalNetworkInputPositions;
        this.rawInputDataSize = Objects.requireNonNull(rawInputDataSize, "rawInputDataSize is null");
        this.inputDataSize = Objects.requireNonNull(inputDataSize, "inputDataSize is null");
        Preconditions.checkArgument((inputPositions >= 0L ? 1 : 0) != 0, (Object)"inputPositions is negative");
        this.inputPositions = inputPositions;
        this.sumSquaredInputPositions = sumSquaredInputPositions;
        this.getOutputCalls = getOutputCalls;
        this.getOutputWall = Objects.requireNonNull(getOutputWall, "getOutputWall is null");
        this.getOutputCpu = Objects.requireNonNull(getOutputCpu, "getOutputCpu is null");
        this.outputDataSize = Objects.requireNonNull(outputDataSize, "outputDataSize is null");
        Preconditions.checkArgument((outputPositions >= 0L ? 1 : 0) != 0, (Object)"outputPositions is negative");
        this.outputPositions = outputPositions;
        this.dynamicFilterSplitsProcessed = dynamicFilterSplitsProcessed;
        this.metrics = Objects.requireNonNull(metrics, "metrics is null");
        this.connectorMetrics = Objects.requireNonNull(connectorMetrics, "connectorMetrics is null");
        this.pipelineMetrics = Objects.requireNonNull(pipelineMetrics, "pipelineMetrics is null");
        this.physicalWrittenDataSize = Objects.requireNonNull(physicalWrittenDataSize, "physicalWrittenDataSize is null");
        this.blockedWall = Objects.requireNonNull(blockedWall, "blockedWall is null");
        this.finishCalls = finishCalls;
        this.finishWall = Objects.requireNonNull(finishWall, "finishWall is null");
        this.finishCpu = Objects.requireNonNull(finishCpu, "finishCpu is null");
        this.userMemoryReservation = Objects.requireNonNull(userMemoryReservation, "userMemoryReservation is null");
        this.revocableMemoryReservation = Objects.requireNonNull(revocableMemoryReservation, "revocableMemoryReservation is null");
        this.peakUserMemoryReservation = Objects.requireNonNull(peakUserMemoryReservation, "peakUserMemoryReservation is null");
        this.peakRevocableMemoryReservation = Objects.requireNonNull(peakRevocableMemoryReservation, "peakRevocableMemoryReservation is null");
        this.peakTotalMemoryReservation = Objects.requireNonNull(peakTotalMemoryReservation, "peakTotalMemoryReservation is null");
        this.spilledDataSize = Objects.requireNonNull(spilledDataSize, "spilledDataSize is null");
        this.blockedReason = blockedReason;
        this.info = info;
    }

    @JsonProperty
    public int getStageId() {
        return this.stageId;
    }

    @JsonProperty
    public int getPipelineId() {
        return this.pipelineId;
    }

    @JsonProperty
    public int getOperatorId() {
        return this.operatorId;
    }

    @JsonProperty
    public PlanNodeId getPlanNodeId() {
        return this.planNodeId;
    }

    @JsonProperty
    public String getOperatorType() {
        return this.operatorType;
    }

    @JsonProperty
    public long getTotalDrivers() {
        return this.totalDrivers;
    }

    @JsonProperty
    public long getAddInputCalls() {
        return this.addInputCalls;
    }

    @JsonProperty
    public Duration getAddInputWall() {
        return this.addInputWall;
    }

    @JsonProperty
    public Duration getAddInputCpu() {
        return this.addInputCpu;
    }

    @JsonProperty
    public DataSize getPhysicalInputDataSize() {
        return this.physicalInputDataSize;
    }

    @JsonProperty
    public long getPhysicalInputPositions() {
        return this.physicalInputPositions;
    }

    @JsonProperty
    public Duration getPhysicalInputReadTime() {
        return this.physicalInputReadTime;
    }

    @JsonProperty
    public DataSize getInternalNetworkInputDataSize() {
        return this.internalNetworkInputDataSize;
    }

    @JsonProperty
    public long getInternalNetworkInputPositions() {
        return this.internalNetworkInputPositions;
    }

    @JsonProperty
    public DataSize getRawInputDataSize() {
        return this.rawInputDataSize;
    }

    @JsonProperty
    public DataSize getInputDataSize() {
        return this.inputDataSize;
    }

    @JsonProperty
    public long getInputPositions() {
        return this.inputPositions;
    }

    @JsonProperty
    public double getSumSquaredInputPositions() {
        return this.sumSquaredInputPositions;
    }

    @JsonProperty
    public long getGetOutputCalls() {
        return this.getOutputCalls;
    }

    @JsonProperty
    public Duration getGetOutputWall() {
        return this.getOutputWall;
    }

    @JsonProperty
    public Duration getGetOutputCpu() {
        return this.getOutputCpu;
    }

    @JsonProperty
    public DataSize getOutputDataSize() {
        return this.outputDataSize;
    }

    @JsonProperty
    public long getOutputPositions() {
        return this.outputPositions;
    }

    @JsonProperty
    public long getDynamicFilterSplitsProcessed() {
        return this.dynamicFilterSplitsProcessed;
    }

    @JsonProperty
    public Metrics getMetrics() {
        return this.metrics;
    }

    @JsonProperty
    public Metrics getConnectorMetrics() {
        return this.connectorMetrics;
    }

    @JsonProperty
    public Metrics getPipelineMetrics() {
        return this.pipelineMetrics;
    }

    @JsonProperty
    public DataSize getPhysicalWrittenDataSize() {
        return this.physicalWrittenDataSize;
    }

    @JsonProperty
    public Duration getBlockedWall() {
        return this.blockedWall;
    }

    @JsonProperty
    public long getFinishCalls() {
        return this.finishCalls;
    }

    @JsonProperty
    public Duration getFinishWall() {
        return this.finishWall;
    }

    @JsonProperty
    public Duration getFinishCpu() {
        return this.finishCpu;
    }

    @JsonProperty
    public DataSize getUserMemoryReservation() {
        return this.userMemoryReservation;
    }

    @JsonProperty
    public DataSize getRevocableMemoryReservation() {
        return this.revocableMemoryReservation;
    }

    @JsonProperty
    public DataSize getPeakUserMemoryReservation() {
        return this.peakUserMemoryReservation;
    }

    @JsonProperty
    public DataSize getPeakRevocableMemoryReservation() {
        return this.peakRevocableMemoryReservation;
    }

    @JsonProperty
    public DataSize getPeakTotalMemoryReservation() {
        return this.peakTotalMemoryReservation;
    }

    @JsonProperty
    public DataSize getSpilledDataSize() {
        return this.spilledDataSize;
    }

    @JsonProperty
    public Optional<BlockedReason> getBlockedReason() {
        return this.blockedReason;
    }

    @Nullable
    @JsonProperty
    public OperatorInfo getInfo() {
        return this.info;
    }

    public OperatorStats addFillingPipelineMetrics(OperatorStats operators, Metrics pipelineMetrics) {
        return this.add((Iterable<OperatorStats>)ImmutableList.of((Object)operators), Optional.of(pipelineMetrics));
    }

    public OperatorStats addFillingPipelineMetrics(Iterable<OperatorStats> operators, Metrics pipelineMetrics) {
        return this.add(operators, Optional.of(pipelineMetrics));
    }

    public OperatorStats add(OperatorStats operators) {
        return this.add((Iterable<OperatorStats>)ImmutableList.of((Object)operators), Optional.empty());
    }

    public OperatorStats add(Iterable<OperatorStats> operators) {
        return this.add(operators, Optional.empty());
    }

    private OperatorStats add(Iterable<OperatorStats> operators, Optional<Metrics> pipelineMetrics) {
        long totalDrivers = this.totalDrivers;
        long addInputCalls = this.addInputCalls;
        long addInputWall = this.addInputWall.roundTo(TimeUnit.NANOSECONDS);
        long addInputCpu = this.addInputCpu.roundTo(TimeUnit.NANOSECONDS);
        long physicalInputDataSize = this.physicalInputDataSize.toBytes();
        long physicalInputPositions = this.physicalInputPositions;
        long physicalInputReadTimeNanos = this.physicalInputReadTime.roundTo(TimeUnit.NANOSECONDS);
        long internalNetworkInputDataSize = this.internalNetworkInputDataSize.toBytes();
        long internalNetworkInputPositions = this.internalNetworkInputPositions;
        long rawInputDataSize = this.rawInputDataSize.toBytes();
        long inputDataSize = this.inputDataSize.toBytes();
        long inputPositions = this.inputPositions;
        double sumSquaredInputPositions = this.sumSquaredInputPositions;
        long getOutputCalls = this.getOutputCalls;
        long getOutputWall = this.getOutputWall.roundTo(TimeUnit.NANOSECONDS);
        long getOutputCpu = this.getOutputCpu.roundTo(TimeUnit.NANOSECONDS);
        long outputDataSize = this.outputDataSize.toBytes();
        long outputPositions = this.outputPositions;
        long dynamicFilterSplitsProcessed = this.dynamicFilterSplitsProcessed;
        Metrics.Accumulator metricsAccumulator = Metrics.accumulator().add(this.getMetrics());
        Metrics.Accumulator connectorMetricsAccumulator = Metrics.accumulator().add(this.getConnectorMetrics());
        Optional<Metrics.Accumulator> pipelineMetricsAccumulator = pipelineMetrics.isPresent() ? Optional.empty() : Optional.of(Metrics.accumulator().add(this.getPipelineMetrics()));
        long physicalWrittenDataSize = this.physicalWrittenDataSize.toBytes();
        long blockedWall = this.blockedWall.roundTo(TimeUnit.NANOSECONDS);
        long finishCalls = this.finishCalls;
        long finishWall = this.finishWall.roundTo(TimeUnit.NANOSECONDS);
        long finishCpu = this.finishCpu.roundTo(TimeUnit.NANOSECONDS);
        long memoryReservation = this.userMemoryReservation.toBytes();
        long revocableMemoryReservation = this.revocableMemoryReservation.toBytes();
        long peakUserMemory = this.peakUserMemoryReservation.toBytes();
        long peakRevocableMemory = this.peakRevocableMemoryReservation.toBytes();
        long peakTotalMemory = this.peakTotalMemoryReservation.toBytes();
        long spilledDataSize = this.spilledDataSize.toBytes();
        Optional<BlockedReason> blockedReason = this.blockedReason;
        Mergeable<OperatorInfo> base = OperatorStats.getMergeableInfoOrNull(this.info);
        ImmutableList.Builder operatorInfos = ImmutableList.builder();
        for (OperatorStats operator : operators) {
            Preconditions.checkArgument((operator.getOperatorId() == this.operatorId ? 1 : 0) != 0, (String)"Expected operatorId to be %s but was %s", (int)this.operatorId, (int)operator.getOperatorId());
            Preconditions.checkArgument((boolean)operator.getOperatorType().equals(this.operatorType), (String)"Expected operatorType to be %s but was %s", (Object)this.operatorType, (Object)operator.getOperatorType());
            totalDrivers += operator.totalDrivers;
            addInputCalls += operator.getAddInputCalls();
            addInputWall += operator.getAddInputWall().roundTo(TimeUnit.NANOSECONDS);
            addInputCpu += operator.getAddInputCpu().roundTo(TimeUnit.NANOSECONDS);
            physicalInputDataSize += operator.getPhysicalInputDataSize().toBytes();
            physicalInputPositions += operator.getPhysicalInputPositions();
            physicalInputReadTimeNanos += operator.getPhysicalInputReadTime().roundTo(TimeUnit.NANOSECONDS);
            internalNetworkInputDataSize += operator.getInternalNetworkInputDataSize().toBytes();
            internalNetworkInputPositions += operator.getInternalNetworkInputPositions();
            rawInputDataSize += operator.getRawInputDataSize().toBytes();
            inputDataSize += operator.getInputDataSize().toBytes();
            inputPositions += operator.getInputPositions();
            sumSquaredInputPositions += operator.getSumSquaredInputPositions();
            getOutputCalls += operator.getGetOutputCalls();
            getOutputWall += operator.getGetOutputWall().roundTo(TimeUnit.NANOSECONDS);
            getOutputCpu += operator.getGetOutputCpu().roundTo(TimeUnit.NANOSECONDS);
            outputDataSize += operator.getOutputDataSize().toBytes();
            outputPositions += operator.getOutputPositions();
            dynamicFilterSplitsProcessed += operator.getDynamicFilterSplitsProcessed();
            metricsAccumulator.add(operator.getMetrics());
            connectorMetricsAccumulator.add(operator.getConnectorMetrics());
            pipelineMetricsAccumulator.ifPresent(accumulator -> accumulator.add(operator.getPipelineMetrics()));
            physicalWrittenDataSize += operator.getPhysicalWrittenDataSize().toBytes();
            finishCalls += operator.getFinishCalls();
            finishWall += operator.getFinishWall().roundTo(TimeUnit.NANOSECONDS);
            finishCpu += operator.getFinishCpu().roundTo(TimeUnit.NANOSECONDS);
            blockedWall += operator.getBlockedWall().roundTo(TimeUnit.NANOSECONDS);
            memoryReservation += operator.getUserMemoryReservation().toBytes();
            revocableMemoryReservation += operator.getRevocableMemoryReservation().toBytes();
            peakUserMemory = Math.max(peakUserMemory, operator.getPeakUserMemoryReservation().toBytes());
            peakRevocableMemory = Math.max(peakRevocableMemory, operator.getPeakRevocableMemoryReservation().toBytes());
            peakTotalMemory = Math.max(peakTotalMemory, operator.getPeakTotalMemoryReservation().toBytes());
            spilledDataSize += operator.getSpilledDataSize().toBytes();
            if (operator.getBlockedReason().isPresent()) {
                blockedReason = operator.getBlockedReason();
            }
            OperatorInfo info = operator.getInfo();
            if (base == null || info == null) continue;
            Verify.verify((base.getClass() == info.getClass() ? 1 : 0) != 0, (String)"Cannot merge operator infos: %s and %s", base, (Object)info);
            operatorInfos.add((Object)info);
        }
        return new OperatorStats(this.stageId, this.pipelineId, this.operatorId, this.planNodeId, this.operatorType, totalDrivers, addInputCalls, new Duration((double)addInputWall, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)addInputCpu, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), DataSize.ofBytes((long)physicalInputDataSize), physicalInputPositions, new Duration((double)physicalInputReadTimeNanos, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), DataSize.ofBytes((long)internalNetworkInputDataSize), internalNetworkInputPositions, DataSize.ofBytes((long)rawInputDataSize), DataSize.ofBytes((long)inputDataSize), inputPositions, sumSquaredInputPositions, getOutputCalls, new Duration((double)getOutputWall, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)getOutputCpu, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), DataSize.ofBytes((long)outputDataSize), outputPositions, dynamicFilterSplitsProcessed, metricsAccumulator.get(), connectorMetricsAccumulator.get(), pipelineMetrics.orElseGet(() -> ((Metrics.Accumulator)pipelineMetricsAccumulator.orElseThrow()).get()), DataSize.ofBytes((long)physicalWrittenDataSize), new Duration((double)blockedWall, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), finishCalls, new Duration((double)finishWall, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)finishCpu, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), DataSize.ofBytes((long)memoryReservation), DataSize.ofBytes((long)revocableMemoryReservation), DataSize.ofBytes((long)peakUserMemory), DataSize.ofBytes((long)peakRevocableMemory), DataSize.ofBytes((long)peakTotalMemory), DataSize.ofBytes((long)spilledDataSize), blockedReason, (OperatorInfo)OperatorStats.mergeInfos(base, operatorInfos.build()));
    }

    private static Mergeable<OperatorInfo> getMergeableInfoOrNull(OperatorInfo info) {
        Mergeable base = null;
        if (info instanceof Mergeable) {
            base = (Mergeable)info;
        }
        return base;
    }

    private static <T> Mergeable<T> mergeInfos(Mergeable<T> base, List<T> others) {
        if (base == null) {
            return null;
        }
        return (Mergeable)base.mergeWith(others);
    }

    public OperatorStats pruneDigests() {
        return new OperatorStats(this.stageId, this.pipelineId, this.operatorId, this.planNodeId, this.operatorType, this.totalDrivers, this.addInputCalls, this.addInputWall, this.addInputCpu, this.physicalInputDataSize, this.physicalInputPositions, this.physicalInputReadTime, this.internalNetworkInputDataSize, this.internalNetworkInputPositions, this.rawInputDataSize, this.inputDataSize, this.inputPositions, this.sumSquaredInputPositions, this.getOutputCalls, this.getOutputWall, this.getOutputCpu, this.outputDataSize, this.outputPositions, this.dynamicFilterSplitsProcessed, DistributionSnapshot.pruneMetrics(this.metrics), DistributionSnapshot.pruneMetrics(this.connectorMetrics), DistributionSnapshot.pruneMetrics(this.pipelineMetrics), this.physicalWrittenDataSize, this.blockedWall, this.finishCalls, this.finishWall, this.finishCpu, this.userMemoryReservation, this.revocableMemoryReservation, this.peakUserMemoryReservation, this.peakRevocableMemoryReservation, this.peakTotalMemoryReservation, this.spilledDataSize, this.blockedReason, this.info);
    }

    public OperatorStats summarize() {
        if (this.info == null || this.info.isFinal()) {
            return this;
        }
        OperatorInfo info = null;
        return new OperatorStats(this.stageId, this.pipelineId, this.operatorId, this.planNodeId, this.operatorType, this.totalDrivers, this.addInputCalls, this.addInputWall, this.addInputCpu, this.physicalInputDataSize, this.physicalInputPositions, this.physicalInputReadTime, this.internalNetworkInputDataSize, this.internalNetworkInputPositions, this.rawInputDataSize, this.inputDataSize, this.inputPositions, this.sumSquaredInputPositions, this.getOutputCalls, this.getOutputWall, this.getOutputCpu, this.outputDataSize, this.outputPositions, this.dynamicFilterSplitsProcessed, this.metrics, this.connectorMetrics, this.pipelineMetrics, this.physicalWrittenDataSize, this.blockedWall, this.finishCalls, this.finishWall, this.finishCpu, this.userMemoryReservation, this.revocableMemoryReservation, this.peakUserMemoryReservation, this.peakRevocableMemoryReservation, this.peakTotalMemoryReservation, this.spilledDataSize, this.blockedReason, info);
    }

    public OperatorStats withPipelineMetrics(Metrics pipelineMetrics) {
        return new OperatorStats(this.stageId, this.pipelineId, this.operatorId, this.planNodeId, this.operatorType, this.totalDrivers, this.addInputCalls, this.addInputWall, this.addInputCpu, this.physicalInputDataSize, this.physicalInputPositions, this.physicalInputReadTime, this.internalNetworkInputDataSize, this.internalNetworkInputPositions, this.rawInputDataSize, this.inputDataSize, this.inputPositions, this.sumSquaredInputPositions, this.getOutputCalls, this.getOutputWall, this.getOutputCpu, this.outputDataSize, this.outputPositions, this.dynamicFilterSplitsProcessed, this.metrics, this.connectorMetrics, pipelineMetrics, this.physicalWrittenDataSize, this.blockedWall, this.finishCalls, this.finishWall, this.finishCpu, this.userMemoryReservation, this.revocableMemoryReservation, this.peakUserMemoryReservation, this.peakRevocableMemoryReservation, this.peakTotalMemoryReservation, this.spilledDataSize, this.blockedReason, this.info);
    }
}

