/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.trino.array.LongBigArray;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.operator.DriverContext;
import io.trino.operator.FlatHashStrategyCompiler;
import io.trino.operator.GroupByHash;
import io.trino.operator.Operator;
import io.trino.operator.OperatorContext;
import io.trino.operator.OperatorFactory;
import io.trino.operator.Work;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.plan.PlanNodeId;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class RowNumberOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final LocalMemoryContext localUserMemoryContext;
    private boolean finishing;
    private final int[] outputChannels;
    private final List<Type> types;
    private int[] partitionIds;
    private int[] groupByChannels;
    private final Optional<GroupByHash> groupByHash;
    private Page inputPage;
    private final LongBigArray partitionRowCount;
    private final Optional<Integer> maxRowsPerPartition;
    private final Optional<PageBuilder> selectedRowPageBuilder;
    private Work<int[]> unfinishedWork;

    public RowNumberOperator(OperatorContext operatorContext, List<Type> sourceTypes, List<Integer> outputChannels, List<Integer> partitionChannels, List<Type> partitionTypes, Optional<Integer> maxRowsPerPartition, Optional<Integer> hashChannel, int expectedPositions, FlatHashStrategyCompiler hashStrategyCompiler) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.localUserMemoryContext = operatorContext.localUserMemoryContext();
        this.outputChannels = Ints.toArray(outputChannels);
        this.types = RowNumberOperator.toTypes(sourceTypes, outputChannels);
        this.maxRowsPerPartition = maxRowsPerPartition;
        this.selectedRowPageBuilder = maxRowsPerPartition.isPresent() ? Optional.of(new PageBuilder(this.types)) : Optional.empty();
        this.partitionRowCount = new LongBigArray(0L);
        if (partitionChannels.isEmpty()) {
            this.groupByHash = Optional.empty();
        } else {
            if (hashChannel.isPresent()) {
                this.groupByChannels = new int[partitionChannels.size() + 1];
                for (int i = 0; i < partitionChannels.size(); ++i) {
                    this.groupByChannels[i] = partitionChannels.get(i);
                }
                this.groupByChannels[partitionChannels.size()] = hashChannel.get();
            } else {
                this.groupByChannels = Ints.toArray(partitionChannels);
            }
            this.groupByHash = Optional.of(GroupByHash.createGroupByHash(operatorContext.getSession(), partitionTypes, hashChannel.isPresent(), false, expectedPositions, hashStrategyCompiler, this::updateMemoryReservation));
        }
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
        this.finishing = true;
    }

    @Override
    public boolean isFinished() {
        if (this.isSinglePartition() && this.maxRowsPerPartition.isPresent()) {
            if (this.finishing && !this.hasUnfinishedInput()) {
                return true;
            }
            return this.partitionRowCount.get(0L) == (long)this.maxRowsPerPartition.get().intValue();
        }
        return this.finishing && !this.hasUnfinishedInput();
    }

    @Override
    public boolean needsInput() {
        if (this.isSinglePartition() && this.maxRowsPerPartition.isPresent()) {
            return this.partitionRowCount.get(0L) < (long)this.maxRowsPerPartition.get().intValue() && !this.finishing && !this.hasUnfinishedInput();
        }
        return !this.finishing && !this.hasUnfinishedInput();
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkState((!this.finishing ? 1 : 0) != 0, (Object)"Operator is already finishing");
        Objects.requireNonNull(page, "page is null");
        Preconditions.checkState((!this.hasUnfinishedInput() ? 1 : 0) != 0);
        this.inputPage = page;
        if (this.groupByHash.isPresent()) {
            this.unfinishedWork = this.groupByHash.get().getGroupIds(this.inputPage.getColumns(this.groupByChannels));
            this.processUnfinishedWork();
        }
        this.updateMemoryReservation();
    }

    @Override
    public Page getOutput() {
        if (this.unfinishedWork != null && !this.processUnfinishedWork()) {
            return null;
        }
        if (this.inputPage == null) {
            return null;
        }
        Page outputPage = this.maxRowsPerPartition.isPresent() ? this.getSelectedRows() : this.getRowsWithRowNumber();
        this.inputPage = null;
        this.updateMemoryReservation();
        return outputPage;
    }

    private boolean hasUnfinishedInput() {
        return this.inputPage != null || this.unfinishedWork != null;
    }

    private boolean updateMemoryReservation() {
        long memorySizeInBytes = this.groupByHash.map(GroupByHash::getEstimatedSize).orElse(0L) + this.partitionRowCount.sizeOf();
        this.localUserMemoryContext.setBytes(memorySizeInBytes);
        return this.operatorContext.isWaitingForMemory().isDone();
    }

    private boolean processUnfinishedWork() {
        Verify.verifyNotNull(this.unfinishedWork);
        if (!this.unfinishedWork.process()) {
            return false;
        }
        this.partitionIds = this.unfinishedWork.getResult();
        this.partitionRowCount.ensureCapacity((long)this.groupByHash.orElseThrow().getGroupCount());
        this.unfinishedWork = null;
        return true;
    }

    private boolean isSinglePartition() {
        return this.groupByHash.isEmpty();
    }

    private Page getRowsWithRowNumber() {
        Block[] outputBlocks = new Block[this.inputPage.getChannelCount() + 1];
        for (int i = 0; i < this.outputChannels.length; ++i) {
            outputBlocks[i] = this.inputPage.getBlock(this.outputChannels[i]);
        }
        outputBlocks[outputBlocks.length - 1] = this.createRowNumberBlock();
        return new Page(this.inputPage.getPositionCount(), outputBlocks);
    }

    private Block createRowNumberBlock() {
        BlockBuilder rowNumberBlock = BigintType.BIGINT.createFixedSizeBlockBuilder(this.inputPage.getPositionCount());
        for (int currentPosition = 0; currentPosition < this.inputPage.getPositionCount(); ++currentPosition) {
            long partitionId = this.getPartitionId(currentPosition);
            long nextRowCount = this.partitionRowCount.get(partitionId) + 1L;
            BigintType.BIGINT.writeLong(rowNumberBlock, nextRowCount);
            this.partitionRowCount.set(partitionId, nextRowCount);
        }
        return rowNumberBlock.build();
    }

    private Page getSelectedRows() {
        Verify.verify((boolean)this.selectedRowPageBuilder.isPresent());
        int rowNumberChannel = this.types.size() - 1;
        PageBuilder pageBuilder = this.selectedRowPageBuilder.get();
        Verify.verify((boolean)pageBuilder.isEmpty());
        for (int currentPosition = 0; currentPosition < this.inputPage.getPositionCount(); ++currentPosition) {
            long partitionId = this.getPartitionId(currentPosition);
            long rowCount = this.partitionRowCount.get(partitionId);
            if (rowCount == (long)this.maxRowsPerPartition.get().intValue()) continue;
            pageBuilder.declarePosition();
            for (int i = 0; i < this.outputChannels.length; ++i) {
                int channel = this.outputChannels[i];
                Type type = this.types.get(i);
                type.appendTo(this.inputPage.getBlock(channel), currentPosition, pageBuilder.getBlockBuilder(i));
            }
            BigintType.BIGINT.writeLong(pageBuilder.getBlockBuilder(rowNumberChannel), rowCount + 1L);
            this.partitionRowCount.set(partitionId, rowCount + 1L);
        }
        if (pageBuilder.isEmpty()) {
            return null;
        }
        Page page = pageBuilder.build();
        pageBuilder.reset();
        return page;
    }

    private long getPartitionId(int position) {
        return this.isSinglePartition() ? 0L : (long)this.partitionIds[position];
    }

    private static List<Type> toTypes(List<? extends Type> sourceTypes, List<Integer> outputChannels) {
        ImmutableList.Builder types = ImmutableList.builder();
        for (int channel : outputChannels) {
            types.add((Object)sourceTypes.get(channel));
        }
        types.add((Object)BigintType.BIGINT);
        return types.build();
    }

    @VisibleForTesting
    public int getCapacity() {
        return this.groupByHash.map(GroupByHash::getCapacity).orElse(0);
    }

    public static class RowNumberOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final Optional<Integer> maxRowsPerPartition;
        private final List<Type> sourceTypes;
        private final List<Integer> outputChannels;
        private final List<Integer> partitionChannels;
        private final List<Type> partitionTypes;
        private final Optional<Integer> hashChannel;
        private final int expectedPositions;
        private boolean closed;
        private final FlatHashStrategyCompiler hashStrategyCompiler;

        public RowNumberOperatorFactory(int operatorId, PlanNodeId planNodeId, List<? extends Type> sourceTypes, List<Integer> outputChannels, List<Integer> partitionChannels, List<? extends Type> partitionTypes, Optional<Integer> maxRowsPerPartition, Optional<Integer> hashChannel, int expectedPositions, FlatHashStrategyCompiler hashStrategyCompiler) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.sourceTypes = ImmutableList.copyOf(sourceTypes);
            this.outputChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(outputChannels, "outputChannels is null"));
            this.partitionChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionChannels, "partitionChannels is null"));
            this.partitionTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionTypes, "partitionTypes is null"));
            this.maxRowsPerPartition = Objects.requireNonNull(maxRowsPerPartition, "maxRowsPerPartition is null");
            this.hashChannel = Objects.requireNonNull(hashChannel, "hashChannel is null");
            Preconditions.checkArgument((expectedPositions > 0 ? 1 : 0) != 0, (Object)"expectedPositions < 0");
            this.expectedPositions = expectedPositions;
            this.hashStrategyCompiler = Objects.requireNonNull(hashStrategyCompiler, "hashStrategyCompiler is null");
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, RowNumberOperator.class.getSimpleName());
            return new RowNumberOperator(operatorContext, this.sourceTypes, this.outputChannels, this.partitionChannels, this.partitionTypes, this.maxRowsPerPartition, this.hashChannel, this.expectedPositions, this.hashStrategyCompiler);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new RowNumberOperatorFactory(this.operatorId, this.planNodeId, this.sourceTypes, this.outputChannels, this.partitionChannels, this.partitionTypes, this.maxRowsPerPartition, this.hashChannel, this.expectedPositions, this.hashStrategyCompiler);
        }
    }
}

