/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.primitives.Ints;
import io.trino.operator.PageWithPositionComparator;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Objects;

public class SimplePageWithPositionComparator
implements PageWithPositionComparator {
    private static final InvocationConvention INVOCATION_CONVENTION = InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION});
    private final int[] sortChannels;
    private final MethodHandle[] orderingOperators;

    public SimplePageWithPositionComparator(List<Type> sortTypes, List<Integer> sortChannels, List<SortOrder> sortOrders, TypeOperators typeOperators) {
        Objects.requireNonNull(sortChannels, "sortChannels is null");
        Objects.requireNonNull(sortTypes, "sortTypes is null");
        Objects.requireNonNull(sortOrders, "sortOrders is null");
        Preconditions.checkArgument((sortTypes.size() == sortChannels.size() ? 1 : 0) != 0, (Object)"sortTypes and sortChannels must be the same size");
        Preconditions.checkArgument((sortTypes.size() == sortOrders.size() ? 1 : 0) != 0, (Object)"sortTypes and sortOrders must be the same size");
        this.sortChannels = Ints.toArray(sortChannels);
        this.orderingOperators = new MethodHandle[this.sortChannels.length];
        for (int index = 0; index < this.sortChannels.length; ++index) {
            Type type = sortTypes.get(index);
            SortOrder sortOrder = sortOrders.get(index);
            this.orderingOperators[index] = typeOperators.getOrderingOperator(type, sortOrder, INVOCATION_CONVENTION);
        }
    }

    @Override
    public int compareTo(Page left, int leftPosition, Page right, int rightPosition) {
        try {
            for (int i = 0; i < this.sortChannels.length; ++i) {
                Block rightBlock;
                MethodHandle orderingOperator = this.orderingOperators[i];
                int sortChannel = this.sortChannels[i];
                Block leftBlock = left.getBlock(sortChannel);
                int compare = orderingOperator.invokeExact(leftBlock, leftPosition, rightBlock = right.getBlock(sortChannel), rightPosition);
                if (compare == 0) continue;
                return compare;
            }
            return 0;
        }
        catch (Throwable throwable) {
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, throwable);
        }
    }
}

