/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Preconditions;
import io.trino.Session;
import io.trino.metadata.Metadata;
import io.trino.metadata.TableExecuteHandle;
import io.trino.operator.DriverContext;
import io.trino.operator.Operator;
import io.trino.operator.OperatorContext;
import io.trino.operator.OperatorFactory;
import io.trino.spi.Page;
import io.trino.sql.planner.plan.PlanNodeId;
import java.util.Objects;

public class SimpleTableExecuteOperator
implements Operator {
    private static final Page PAGE = new Page(0);
    private final OperatorContext operatorContext;
    private final Metadata metadata;
    private final Session session;
    private final TableExecuteHandle executeHandle;
    private boolean finished;

    public SimpleTableExecuteOperator(OperatorContext operatorContext, Metadata metadata, Session session, TableExecuteHandle executeHandle) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.executeHandle = Objects.requireNonNull(executeHandle, "executeHandle is null");
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public boolean needsInput() {
        return false;
    }

    @Override
    public void addInput(Page page) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Page getOutput() {
        if (this.finished) {
            return null;
        }
        this.metadata.executeTableExecute(this.session, this.executeHandle);
        this.finished = true;
        return PAGE;
    }

    @Override
    public void finish() {
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    public static class SimpleTableExecuteOperatorOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final Metadata metadata;
        private final Session session;
        private final TableExecuteHandle executeHandle;
        private boolean closed;

        public SimpleTableExecuteOperatorOperatorFactory(int operatorId, PlanNodeId planNodeId, Metadata metadata, Session session, TableExecuteHandle executeHandle) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.metadata = Objects.requireNonNull(metadata, "planNodeId is null");
            this.session = Objects.requireNonNull(session, "planNodeId is null");
            this.executeHandle = Objects.requireNonNull(executeHandle, "executeHandle is null");
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext context = driverContext.addOperatorContext(this.operatorId, this.planNodeId, SimpleTableExecuteOperator.class.getSimpleName());
            return new SimpleTableExecuteOperator(context, this.metadata, this.session, this.executeHandle);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new SimpleTableExecuteOperatorOperatorFactory(this.operatorId, this.planNodeId, this.metadata, this.session, this.executeHandle);
        }
    }
}

