/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.operator.GroupedTopNRowNumberBuilder;
import io.trino.operator.NoChannelGroupByHash;
import io.trino.operator.PageWithPositionComparator;
import io.trino.spi.Page;
import io.trino.spi.type.Type;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class TopNProcessor {
    private final LocalMemoryContext localUserMemoryContext;
    private final GroupedTopNRowNumberBuilder topNBuilder;
    private Iterator<Page> outputIterator;

    public TopNProcessor(AggregatedMemoryContext aggregatedMemoryContext, List<Type> types, int n, PageWithPositionComparator comparator) {
        Objects.requireNonNull(aggregatedMemoryContext, "aggregatedMemoryContext is null");
        Preconditions.checkArgument((n > 0 ? 1 : 0) != 0, (String)"n must be > 0, found: %s", (int)n);
        this.localUserMemoryContext = aggregatedMemoryContext.newLocalMemoryContext(TopNProcessor.class.getSimpleName());
        this.topNBuilder = new GroupedTopNRowNumberBuilder(types, comparator, n, false, new int[0], new NoChannelGroupByHash());
    }

    public void addInput(Page page) {
        boolean done = this.topNBuilder.processPage(Objects.requireNonNull(page, "page is null")).process();
        Verify.verify((boolean)done);
        this.updateMemoryReservation();
    }

    public Page getOutput() {
        if (this.outputIterator == null) {
            this.outputIterator = this.topNBuilder.buildResult();
        }
        Page output = null;
        if (this.outputIterator.hasNext()) {
            output = this.outputIterator.next();
        } else {
            this.outputIterator = Collections.emptyIterator();
        }
        this.updateMemoryReservation();
        return output;
    }

    public boolean noMoreOutput() {
        return this.outputIterator != null && !this.outputIterator.hasNext();
    }

    private void updateMemoryReservation() {
        this.localUserMemoryContext.setBytes(this.topNBuilder.getEstimatedSizeInBytes());
    }
}

