/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.trino.annotation.UsedByGeneratedCode;
import io.trino.operator.aggregation.state.LongAndDoubleState;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.WindowAccumulator;
import io.trino.spi.function.WindowIndex;
import io.trino.spi.type.DoubleType;

@AggregationFunction(value="avg", windowAccumulator=DoubleAverageWindowAccumulator.class)
public final class DoubleAverageAggregations {
    private DoubleAverageAggregations() {
    }

    @InputFunction
    public static void input(@AggregationState LongAndDoubleState state, @SqlType(value="double") double value) {
        state.setLong(state.getLong() + 1L);
        state.setDouble(state.getDouble() + value);
    }

    @CombineFunction
    public static void combine(@AggregationState LongAndDoubleState state, @AggregationState LongAndDoubleState otherState) {
        state.setLong(state.getLong() + otherState.getLong());
        state.setDouble(state.getDouble() + otherState.getDouble());
    }

    @OutputFunction(value="double")
    public static void output(@AggregationState LongAndDoubleState state, BlockBuilder out) {
        long count = state.getLong();
        if (count == 0L) {
            out.appendNull();
        } else {
            double value = state.getDouble();
            DoubleType.DOUBLE.writeDouble(out, value / (double)count);
        }
    }

    public static class DoubleAverageWindowAccumulator
    implements WindowAccumulator {
        private long count;
        private double sum;

        @UsedByGeneratedCode
        public DoubleAverageWindowAccumulator() {
        }

        private DoubleAverageWindowAccumulator(long count, double sum) {
            this.count = count;
            this.sum = sum;
        }

        public long getEstimatedSize() {
            return 16L;
        }

        public WindowAccumulator copy() {
            return new DoubleAverageWindowAccumulator(this.count, this.sum);
        }

        public void addInput(WindowIndex index, int startPosition, int endPosition) {
            for (int i = startPosition; i <= endPosition; ++i) {
                if (index.isNull(0, i)) continue;
                this.sum += index.getDouble(0, i);
                ++this.count;
            }
        }

        public boolean removeInput(WindowIndex index, int startPosition, int endPosition) {
            if (!Double.isFinite(this.sum)) {
                return false;
            }
            for (int i = startPosition; i <= endPosition; ++i) {
                if (index.isNull(0, i)) continue;
                this.sum -= index.getDouble(0, i);
                --this.count;
            }
            return true;
        }

        public void output(BlockBuilder blockBuilder) {
            if (this.count == 0L) {
                blockBuilder.appendNull();
            } else {
                DoubleType.DOUBLE.writeDouble(blockBuilder, this.sum / (double)this.count);
            }
        }
    }
}

