/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.BlockIndex;
import io.trino.spi.function.BlockPosition;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.Convention;
import io.trino.spi.function.Description;
import io.trino.spi.function.InOut;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorDependency;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import java.lang.invoke.MethodHandle;

@AggregationFunction(value="max")
@Description(value="Returns the maximum value of the argument")
public final class MaxAggregationFunction {
    private MaxAggregationFunction() {
    }

    @InputFunction
    @TypeParameter(value="T")
    public static void input(@OperatorDependency(operator=OperatorType.COMPARISON_UNORDERED_FIRST, argumentTypes={"T", "T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.VALUE_BLOCK_POSITION_NOT_NULL, InvocationConvention.InvocationArgumentConvention.IN_OUT}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle compare, @AggregationState(value={"T"}) InOut state, @BlockPosition @SqlType(value="T") ValueBlock block, @BlockIndex int position) throws Throwable {
        if (state.isNull() || compare.invokeExact(block, position, state) > 0L) {
            state.set((Block)block, position);
        }
    }

    @CombineFunction
    public static void combine(@OperatorDependency(operator=OperatorType.COMPARISON_UNORDERED_FIRST, argumentTypes={"T", "T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.IN_OUT, InvocationConvention.InvocationArgumentConvention.IN_OUT}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle compare, @AggregationState(value={"T"}) InOut state, @AggregationState(value={"T"}) InOut otherState) throws Throwable {
        if (state.isNull() || compare.invokeExact(otherState, state) > 0L) {
            state.set(otherState);
        }
    }

    @OutputFunction(value="T")
    public static void output(@AggregationState(value={"T"}) InOut state, BlockBuilder out) {
        state.get(out);
    }
}

