/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.airlift.slice.Slice;
import io.trino.array.ObjectBigArray;
import io.trino.operator.aggregation.ApproximateMostFrequentHistogram;
import io.trino.operator.aggregation.VarcharApproximateMostFrequent;
import io.trino.operator.aggregation.state.AbstractGroupedAccumulatorState;
import io.trino.spi.function.AccumulatorStateFactory;

public class StringApproximateMostFrequentStateFactory
implements AccumulatorStateFactory<VarcharApproximateMostFrequent.State> {
    public VarcharApproximateMostFrequent.State createSingleState() {
        return new SingleLongApproximateMostFrequentState();
    }

    public VarcharApproximateMostFrequent.State createGroupedState() {
        return new GroupedLongApproximateMostFrequentState();
    }

    public static class SingleLongApproximateMostFrequentState
    implements VarcharApproximateMostFrequent.State {
        private ApproximateMostFrequentHistogram<Slice> histogram;
        private long size;

        @Override
        public ApproximateMostFrequentHistogram<Slice> get() {
            return this.histogram;
        }

        @Override
        public void set(ApproximateMostFrequentHistogram<Slice> histogram) {
            this.histogram = histogram;
            this.size = histogram.estimatedInMemorySize();
        }

        public long getEstimatedSize() {
            return this.size;
        }
    }

    public static class GroupedLongApproximateMostFrequentState
    extends AbstractGroupedAccumulatorState
    implements VarcharApproximateMostFrequent.State {
        private final ObjectBigArray<ApproximateMostFrequentHistogram<Slice>> histograms = new ObjectBigArray();
        private long size;

        @Override
        public ApproximateMostFrequentHistogram<Slice> get() {
            return (ApproximateMostFrequentHistogram)this.histograms.get((long)this.getGroupId());
        }

        @Override
        public void set(ApproximateMostFrequentHistogram<Slice> histogram) {
            ApproximateMostFrequentHistogram previous = (ApproximateMostFrequentHistogram)this.histograms.getAndSet((long)this.getGroupId(), histogram);
            this.size += histogram.estimatedInMemorySize();
            if (previous != null) {
                this.size -= previous.estimatedInMemorySize();
            }
        }

        public void ensureCapacity(int size) {
            this.histograms.ensureCapacity((long)size);
        }

        public long getEstimatedSize() {
            return this.size + this.histograms.sizeOf();
        }
    }
}

