/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.airlift.slice.Slice;
import io.trino.operator.aggregation.ApproximateMostFrequentHistogram;
import io.trino.operator.aggregation.StringApproximateMostFrequentStateFactory;
import io.trino.operator.aggregation.StringApproximateMostFrequentStateSerializer;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.MapBlockBuilder;
import io.trino.spi.function.AccumulatorState;
import io.trino.spi.function.AccumulatorStateMetadata;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.VarcharType;
import io.trino.util.Failures;

@AggregationFunction(value="approx_most_frequent")
public final class VarcharApproximateMostFrequent {
    private VarcharApproximateMostFrequent() {
    }

    @InputFunction
    public static void input(@AggregationState State state, @SqlType(value="bigint") long buckets, @SqlType(value="varchar") Slice value, @SqlType(value="bigint") long capacity) {
        ApproximateMostFrequentHistogram<Slice> histogram = state.get();
        if (histogram == null) {
            Failures.checkCondition(buckets >= 2L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "approx_most_frequent bucket count must be greater than one", new Object[0]);
            histogram = new ApproximateMostFrequentHistogram<Slice>(Math.toIntExact(buckets), Math.toIntExact(capacity), StringApproximateMostFrequentStateSerializer::serializeBucket, StringApproximateMostFrequentStateSerializer::deserializeBucket);
            state.set(histogram);
        }
        histogram.add(value);
    }

    @CombineFunction
    public static void combine(@AggregationState State state, @AggregationState State otherState) {
        ApproximateMostFrequentHistogram<Slice> otherHistogram = otherState.get();
        ApproximateMostFrequentHistogram<Slice> histogram = state.get();
        if (histogram == null) {
            state.set(otherHistogram);
        } else {
            histogram.merge(otherHistogram);
        }
    }

    @OutputFunction(value="map(varchar,bigint)")
    public static void output(@AggregationState State state, BlockBuilder out) {
        if (state.get() == null) {
            out.appendNull();
        } else {
            ((MapBlockBuilder)out).buildEntry((keyBuilder, valueBuilder) -> state.get().forEachBucket((key, value) -> {
                VarcharType.VARCHAR.writeSlice(keyBuilder, key);
                BigintType.BIGINT.writeLong(valueBuilder, value);
            }));
        }
    }

    @AccumulatorStateMetadata(stateSerializerClass=StringApproximateMostFrequentStateSerializer.class, stateFactoryClass=StringApproximateMostFrequentStateFactory.class)
    public static interface State
    extends AccumulatorState {
        public ApproximateMostFrequentHistogram<Slice> get();

        public void set(ApproximateMostFrequentHistogram<Slice> var1);
    }
}

