/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.minmaxbyn;

import io.trino.operator.aggregation.minmaxbyn.MinByNState;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.BlockIndex;
import io.trino.spi.function.BlockPosition;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.Description;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.SqlNullable;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.function.TypeParameters;

@AggregationFunction(value="min_by")
@Description(value="Returns the values of the first argument associated with the minimum values of the second argument")
public final class MinByNAggregationFunction {
    private MinByNAggregationFunction() {
    }

    @InputFunction
    @TypeParameters(value={@TypeParameter(value="K"), @TypeParameter(value="V")})
    public static void input(@AggregationState(value={"K", "V"}) MinByNState state, @SqlNullable @BlockPosition @SqlType(value="V") ValueBlock valueBlock, @BlockIndex int valuePosition, @BlockPosition @SqlType(value="K") ValueBlock keyBlock, @BlockIndex int keyPosition, @SqlType(value="BIGINT") long n) {
        state.initialize(n);
        state.add(keyBlock, keyPosition, valueBlock, valuePosition);
    }

    @CombineFunction
    public static void combine(@AggregationState(value={"K", "V"}) MinByNState state, @AggregationState(value={"K", "V"}) MinByNState otherState) {
        state.merge(otherState);
    }

    @OutputFunction(value="array(V)")
    public static void output(@AggregationState(value={"K", "V"}) MinByNState state, BlockBuilder out) {
        state.popAll(out);
    }
}

