/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.state;

import io.airlift.slice.SizeOf;
import io.airlift.stats.QuantileDigest;
import io.trino.array.ObjectBigArray;
import io.trino.operator.aggregation.state.AbstractGroupedAccumulatorState;
import io.trino.operator.aggregation.state.QuantileDigestState;
import io.trino.spi.function.AccumulatorStateFactory;
import java.util.Objects;

public class QuantileDigestStateFactory
implements AccumulatorStateFactory<QuantileDigestState> {
    public QuantileDigestState createSingleState() {
        return new SingleQuantileDigestState();
    }

    public QuantileDigestState createGroupedState() {
        return new GroupedQuantileDigestState();
    }

    public static class SingleQuantileDigestState
    implements QuantileDigestState {
        private static final int INSTANCE_SIZE = SizeOf.instanceSize(SingleQuantileDigestState.class);
        private QuantileDigest qdigest;

        @Override
        public QuantileDigest getQuantileDigest() {
            return this.qdigest;
        }

        @Override
        public void setQuantileDigest(QuantileDigest value) {
            this.qdigest = value;
        }

        @Override
        public void addMemoryUsage(int value) {
        }

        public long getEstimatedSize() {
            long estimatedSize = INSTANCE_SIZE;
            if (this.qdigest != null) {
                estimatedSize += (long)this.qdigest.estimatedInMemorySizeInBytes();
            }
            return estimatedSize;
        }
    }

    public static class GroupedQuantileDigestState
    extends AbstractGroupedAccumulatorState
    implements QuantileDigestState {
        private static final int INSTANCE_SIZE = SizeOf.instanceSize(GroupedQuantileDigestState.class);
        private final ObjectBigArray<QuantileDigest> qdigests = new ObjectBigArray();
        private long size;

        public void ensureCapacity(int size) {
            this.qdigests.ensureCapacity((long)size);
        }

        @Override
        public QuantileDigest getQuantileDigest() {
            return (QuantileDigest)this.qdigests.get((long)this.getGroupId());
        }

        @Override
        public void setQuantileDigest(QuantileDigest value) {
            Objects.requireNonNull(value, "value is null");
            this.qdigests.set((long)this.getGroupId(), (Object)value);
        }

        @Override
        public void addMemoryUsage(int value) {
            this.size += (long)value;
        }

        public long getEstimatedSize() {
            return (long)INSTANCE_SIZE + this.size + this.qdigests.sizeOf();
        }
    }
}

