/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.exchange;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.operator.exchange.LocalExchangeMemoryManager;
import io.trino.operator.exchange.LocalExchanger;
import io.trino.spi.Page;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;

class RandomExchanger
implements LocalExchanger {
    private final List<Consumer<Page>> buffers;
    private final LocalExchangeMemoryManager memoryManager;

    public RandomExchanger(List<Consumer<Page>> buffers, LocalExchangeMemoryManager memoryManager) {
        this.buffers = ImmutableList.copyOf((Collection)Objects.requireNonNull(buffers, "buffers is null"));
        this.memoryManager = Objects.requireNonNull(memoryManager, "memoryManager is null");
    }

    @Override
    public void accept(Page page) {
        this.memoryManager.updateMemoryUsage(page.getRetainedSizeInBytes());
        int randomIndex = ThreadLocalRandom.current().nextInt(this.buffers.size());
        this.buffers.get(randomIndex).accept(page);
    }

    @Override
    public ListenableFuture<Void> waitForWriting() {
        return this.memoryManager.getNotFullFuture();
    }
}

