/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.function;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.operator.DriverContext;
import io.trino.operator.Operator;
import io.trino.operator.OperatorContext;
import io.trino.operator.OperatorFactory;
import io.trino.operator.PageBuffer;
import io.trino.operator.PagesHashStrategy;
import io.trino.operator.PagesIndex;
import io.trino.operator.PositionSearcher;
import io.trino.operator.WorkProcessor;
import io.trino.operator.function.EmptyTableFunctionPartition;
import io.trino.operator.function.RegularTableFunctionPartition;
import io.trino.operator.function.TableFunctionPartition;
import io.trino.spi.Page;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.function.table.ConnectorTableFunctionHandle;
import io.trino.spi.function.table.TableFunctionProcessorProvider;
import io.trino.spi.type.Type;
import io.trino.sql.planner.plan.PlanNodeId;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

public class TableFunctionOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final ConnectorSession session;
    private final PageBuffer pageBuffer = new PageBuffer();
    private final WorkProcessor<Page> outputPages;
    private final boolean processEmptyInput;

    public TableFunctionOperator(OperatorContext operatorContext, TableFunctionProcessorProvider tableFunctionProvider, CatalogHandle catalogHandle, ConnectorTableFunctionHandle functionHandle, int properChannelsCount, int passThroughSourcesCount, List<List<Integer>> requiredChannels, Optional<Map<Integer, Integer>> markerChannels, List<RegularTableFunctionPartition.PassThroughColumnSpecification> passThroughSpecifications, boolean pruneWhenEmpty, List<Integer> partitionChannels, List<Integer> prePartitionedChannels, List<Integer> sortChannels, List<SortOrder> sortOrders, int preSortedPrefix, List<Type> sourceTypes, int expectedPositions, PagesIndex.Factory pagesIndexFactory) {
        Objects.requireNonNull(operatorContext, "operatorContext is null");
        Objects.requireNonNull(tableFunctionProvider, "tableFunctionProvider is null");
        Objects.requireNonNull(catalogHandle, "catalogHandle is null");
        Objects.requireNonNull(functionHandle, "functionHandle is null");
        Objects.requireNonNull(requiredChannels, "requiredChannels is null");
        Objects.requireNonNull(markerChannels, "markerChannels is null");
        Objects.requireNonNull(passThroughSpecifications, "passThroughSpecifications is null");
        Objects.requireNonNull(partitionChannels, "partitionChannels is null");
        Objects.requireNonNull(prePartitionedChannels, "prePartitionedChannels is null");
        Preconditions.checkArgument((boolean)partitionChannels.containsAll(prePartitionedChannels), (Object)"prePartitionedChannels must be a subset of partitionChannels");
        Objects.requireNonNull(sortChannels, "sortChannels is null");
        Objects.requireNonNull(sortOrders, "sortOrders is null");
        Preconditions.checkArgument((sortChannels.size() == sortOrders.size() ? 1 : 0) != 0, (Object)"The number of sort channels must be equal to the number of sort orders");
        Preconditions.checkArgument((preSortedPrefix <= sortChannels.size() ? 1 : 0) != 0, (Object)"The number of pre-sorted channels must be lower or equal to the number of sort channels");
        Preconditions.checkArgument((preSortedPrefix == 0 || ImmutableSet.copyOf(prePartitionedChannels).equals((Object)ImmutableSet.copyOf(partitionChannels)) ? 1 : 0) != 0, (Object)"preSortedPrefix can only be greater than zero if all partition channels are pre-grouped");
        Objects.requireNonNull(sourceTypes, "sourceTypes is null");
        Objects.requireNonNull(pagesIndexFactory, "pagesIndexFactory is null");
        this.operatorContext = operatorContext;
        this.session = operatorContext.getSession().toConnectorSession(catalogHandle);
        this.processEmptyInput = !pruneWhenEmpty;
        PagesIndex pagesIndex = pagesIndexFactory.newPagesIndex(sourceTypes, expectedPositions);
        HashStrategies hashStrategies = new HashStrategies(pagesIndex, partitionChannels, prePartitionedChannels, sortChannels, sortOrders, preSortedPrefix);
        this.outputPages = this.pageBuffer.pages().transform(new PartitionAndSort(this, pagesIndex, hashStrategies, this.processEmptyInput)).flatMap(groupPagesIndex -> this.pagesIndexToTableFunctionPartitions((PagesIndex)groupPagesIndex, hashStrategies, tableFunctionProvider, this.session, functionHandle, properChannelsCount, passThroughSourcesCount, requiredChannels, markerChannels, passThroughSpecifications, this.processEmptyInput)).flatMap(TableFunctionPartition::toOutputPages);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
        this.pageBuffer.finish();
    }

    @Override
    public boolean isFinished() {
        return this.outputPages.isFinished();
    }

    @Override
    public ListenableFuture<Void> isBlocked() {
        if (this.outputPages.isBlocked()) {
            return this.outputPages.getBlockedFuture();
        }
        return NOT_BLOCKED;
    }

    @Override
    public boolean needsInput() {
        return this.pageBuffer.isEmpty() && !this.pageBuffer.isFinished();
    }

    @Override
    public void addInput(Page page) {
        this.pageBuffer.add(page);
    }

    @Override
    public Page getOutput() {
        if (!this.outputPages.process()) {
            return null;
        }
        if (this.outputPages.isFinished()) {
            return null;
        }
        return this.outputPages.getResult();
    }

    private static int appendCurrentGroup(PagesIndex pagesIndex, HashStrategies hashStrategies, Page page, int startPosition) {
        Preconditions.checkArgument((page.getPositionCount() > startPosition ? 1 : 0) != 0);
        PagesHashStrategy prePartitionedStrategy = hashStrategies.prePartitionedStrategy;
        Page prePartitionedPage = page.getColumns(hashStrategies.prePartitionedChannelsArray);
        if (pagesIndex.getPositionCount() == 0 || pagesIndex.positionIdenticalToRow(prePartitionedStrategy, 0, startPosition, prePartitionedPage)) {
            int groupEnd = TableFunctionOperator.findGroupEnd(prePartitionedPage, prePartitionedStrategy, startPosition);
            pagesIndex.addPage(page.getRegion(startPosition, groupEnd - startPosition));
            if (page.getPositionCount() - groupEnd > 0) {
                return groupEnd;
            }
            return page.getPositionCount();
        }
        return startPosition;
    }

    private static void sortCurrentGroup(PagesIndex pagesIndex, HashStrategies hashStrategies) {
        PagesHashStrategy preSortedStrategy = hashStrategies.preSortedStrategy;
        List<Integer> remainingPartitionAndSortChannels = hashStrategies.remainingPartitionAndSortChannels;
        List<SortOrder> remainingSortOrders = hashStrategies.remainingSortOrders;
        if (pagesIndex.getPositionCount() > 1 && !remainingPartitionAndSortChannels.isEmpty()) {
            int startPosition = 0;
            while (startPosition < pagesIndex.getPositionCount()) {
                int endPosition = TableFunctionOperator.findGroupEnd(pagesIndex, preSortedStrategy, startPosition);
                pagesIndex.sort(remainingPartitionAndSortChannels, remainingSortOrders, startPosition, endPosition);
                startPosition = endPosition;
            }
        }
    }

    private static int findGroupEnd(Page page, PagesHashStrategy pagesHashStrategy, int startPosition) {
        Preconditions.checkArgument((page.getPositionCount() > 0 ? 1 : 0) != 0, (Object)"Must have at least one position");
        Preconditions.checkPositionIndex((int)startPosition, (int)page.getPositionCount(), (String)"startPosition out of bounds");
        return PositionSearcher.findEndPosition(startPosition, page.getPositionCount(), (firstPosition, secondPosition) -> pagesHashStrategy.rowIdenticalToRow(firstPosition, page, secondPosition, page));
    }

    private static int findGroupEnd(PagesIndex pagesIndex, PagesHashStrategy pagesHashStrategy, int startPosition) {
        Preconditions.checkArgument((pagesIndex.getPositionCount() > 0 ? 1 : 0) != 0, (Object)"Must have at least one position");
        Preconditions.checkPositionIndex((int)startPosition, (int)pagesIndex.getPositionCount(), (String)"startPosition out of bounds");
        return PositionSearcher.findEndPosition(startPosition, pagesIndex.getPositionCount(), (firstPosition, secondPosition) -> pagesIndex.positionIdenticalToPosition(pagesHashStrategy, firstPosition, secondPosition));
    }

    private WorkProcessor<TableFunctionPartition> pagesIndexToTableFunctionPartitions(final PagesIndex pagesIndex, HashStrategies hashStrategies, final TableFunctionProcessorProvider tableFunctionProvider, final ConnectorSession session, final ConnectorTableFunctionHandle functionHandle, final int properChannelsCount, final int passThroughSourcesCount, final List<List<Integer>> requiredChannels, final Optional<Map<Integer, Integer>> markerChannels, final List<RegularTableFunctionPartition.PassThroughColumnSpecification> passThroughSpecifications, final boolean processEmptyInput) {
        final PagesHashStrategy remainingPartitionStrategy = hashStrategies.remainingPartitionStrategy;
        return WorkProcessor.create(new WorkProcessor.Process<TableFunctionPartition>(this){
            private int partitionStart;
            private boolean processEmpty;
            {
                this.processEmpty = processEmptyInput;
            }

            @Override
            public WorkProcessor.ProcessState<TableFunctionPartition> process() {
                if (this.partitionStart == pagesIndex.getPositionCount()) {
                    if (this.processEmpty && pagesIndex.getPositionCount() == 0) {
                        this.processEmpty = false;
                        return WorkProcessor.ProcessState.ofResult(new EmptyTableFunctionPartition(tableFunctionProvider.getDataProcessor(session, functionHandle), properChannelsCount, passThroughSourcesCount, (List)passThroughSpecifications.stream().map(RegularTableFunctionPartition.PassThroughColumnSpecification::inputChannel).map(pagesIndex::getType).collect(ImmutableList.toImmutableList())));
                    }
                    return WorkProcessor.ProcessState.finished();
                }
                this.processEmpty = false;
                int partitionEnd = TableFunctionOperator.findGroupEnd(pagesIndex, remainingPartitionStrategy, this.partitionStart);
                RegularTableFunctionPartition partition = new RegularTableFunctionPartition(pagesIndex, this.partitionStart, partitionEnd, tableFunctionProvider.getDataProcessor(session, functionHandle), properChannelsCount, passThroughSourcesCount, requiredChannels, markerChannels, passThroughSpecifications);
                this.partitionStart = partitionEnd;
                return WorkProcessor.ProcessState.ofResult(partition);
            }
        });
    }

    private static class HashStrategies {
        final PagesHashStrategy prePartitionedStrategy;
        final PagesHashStrategy remainingPartitionStrategy;
        final PagesHashStrategy preSortedStrategy;
        final List<Integer> remainingPartitionAndSortChannels;
        final List<SortOrder> remainingSortOrders;
        final int[] prePartitionedChannelsArray;

        public HashStrategies(PagesIndex pagesIndex, List<Integer> partitionChannels, List<Integer> prePartitionedChannels, List<Integer> sortChannels, List<SortOrder> sortOrders, int preSortedPrefix) {
            this.prePartitionedStrategy = pagesIndex.createPagesHashStrategy(prePartitionedChannels, OptionalInt.empty());
            List remainingPartitionChannels = (List)partitionChannels.stream().filter(channel -> !prePartitionedChannels.contains(channel)).collect(ImmutableList.toImmutableList());
            this.remainingPartitionStrategy = pagesIndex.createPagesHashStrategy(remainingPartitionChannels, OptionalInt.empty());
            List preSortedChannels = (List)sortChannels.stream().limit(preSortedPrefix).collect(ImmutableList.toImmutableList());
            this.preSortedStrategy = pagesIndex.createPagesHashStrategy(preSortedChannels, OptionalInt.empty());
            if (preSortedPrefix > 0) {
                this.remainingPartitionAndSortChannels = ImmutableList.copyOf((Iterable)Iterables.skip(sortChannels, (int)preSortedPrefix));
                this.remainingSortOrders = ImmutableList.copyOf((Iterable)Iterables.skip(sortOrders, (int)preSortedPrefix));
            } else {
                this.remainingPartitionAndSortChannels = ImmutableList.copyOf((Iterable)Iterables.concat((Iterable)remainingPartitionChannels, sortChannels));
                this.remainingSortOrders = ImmutableList.copyOf((Iterable)Iterables.concat(Collections.nCopies(remainingPartitionChannels.size(), SortOrder.ASC_NULLS_LAST), sortOrders));
            }
            this.prePartitionedChannelsArray = Ints.toArray(prePartitionedChannels);
        }
    }

    private class PartitionAndSort
    implements WorkProcessor.Transformation<Page, PagesIndex> {
        private final PagesIndex pagesIndex;
        private final HashStrategies hashStrategies;
        private final LocalMemoryContext memoryContext;
        private boolean resetPagesIndex;
        private int inputPosition;
        private boolean processEmptyInput;

        public PartitionAndSort(TableFunctionOperator tableFunctionOperator, PagesIndex pagesIndex, HashStrategies hashStrategies, boolean processEmptyInput) {
            this.pagesIndex = pagesIndex;
            this.hashStrategies = hashStrategies;
            this.memoryContext = tableFunctionOperator.operatorContext.aggregateUserMemoryContext().newLocalMemoryContext(PartitionAndSort.class.getSimpleName());
            this.processEmptyInput = processEmptyInput;
        }

        @Override
        public WorkProcessor.TransformationState<PagesIndex> process(Page input) {
            if (this.resetPagesIndex) {
                this.pagesIndex.clear();
                this.updateMemoryUsage();
                this.resetPagesIndex = false;
            }
            if (input == null && this.pagesIndex.getPositionCount() == 0) {
                if (this.processEmptyInput) {
                    this.processEmptyInput = false;
                    return WorkProcessor.TransformationState.ofResult(this.pagesIndex, false);
                }
                this.memoryContext.close();
                return WorkProcessor.TransformationState.finished();
            }
            this.processEmptyInput = false;
            if (input != null) {
                this.inputPosition = TableFunctionOperator.appendCurrentGroup(this.pagesIndex, this.hashStrategies, input, this.inputPosition);
                this.updateMemoryUsage();
                if (this.inputPosition >= input.getPositionCount()) {
                    this.inputPosition = 0;
                    return WorkProcessor.TransformationState.needsMoreData();
                }
            }
            TableFunctionOperator.sortCurrentGroup(this.pagesIndex, this.hashStrategies);
            this.resetPagesIndex = true;
            return WorkProcessor.TransformationState.ofResult(this.pagesIndex, false);
        }

        void updateMemoryUsage() {
            this.memoryContext.setBytes(this.pagesIndex.getEstimatedSize().toBytes());
        }
    }

    public static class TableFunctionOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final TableFunctionProcessorProvider tableFunctionProvider;
        private final CatalogHandle catalogHandle;
        private final ConnectorTableFunctionHandle functionHandle;
        private final int properChannelsCount;
        private final int passThroughSourcesCount;
        private final List<List<Integer>> requiredChannels;
        private final Optional<Map<Integer, Integer>> markerChannels;
        private final List<RegularTableFunctionPartition.PassThroughColumnSpecification> passThroughSpecifications;
        private final boolean pruneWhenEmpty;
        private final List<Integer> partitionChannels;
        private final List<Integer> prePartitionedChannels;
        private final List<Integer> sortChannels;
        private final List<SortOrder> sortOrders;
        private final int preSortedPrefix;
        private final List<Type> sourceTypes;
        private final int expectedPositions;
        private final PagesIndex.Factory pagesIndexFactory;
        private boolean closed;

        public TableFunctionOperatorFactory(int operatorId, PlanNodeId planNodeId, TableFunctionProcessorProvider tableFunctionProvider, CatalogHandle catalogHandle, ConnectorTableFunctionHandle functionHandle, int properChannelsCount, int passThroughSourcesCount, List<List<Integer>> requiredChannels, Optional<Map<Integer, Integer>> markerChannels, List<RegularTableFunctionPartition.PassThroughColumnSpecification> passThroughSpecifications, boolean pruneWhenEmpty, List<Integer> partitionChannels, List<Integer> prePartitionedChannels, List<Integer> sortChannels, List<SortOrder> sortOrders, int preSortedPrefix, List<? extends Type> sourceTypes, int expectedPositions, PagesIndex.Factory pagesIndexFactory) {
            Objects.requireNonNull(planNodeId, "planNodeId is null");
            Objects.requireNonNull(tableFunctionProvider, "tableFunctionProvider is null");
            Objects.requireNonNull(functionHandle, "functionHandle is null");
            Objects.requireNonNull(requiredChannels, "requiredChannels is null");
            Objects.requireNonNull(markerChannels, "markerChannels is null");
            Objects.requireNonNull(passThroughSpecifications, "passThroughSpecifications is null");
            Objects.requireNonNull(partitionChannels, "partitionChannels is null");
            Objects.requireNonNull(prePartitionedChannels, "prePartitionedChannels is null");
            Preconditions.checkArgument((boolean)partitionChannels.containsAll(prePartitionedChannels), (Object)"prePartitionedChannels must be a subset of partitionChannels");
            Objects.requireNonNull(sortChannels, "sortChannels is null");
            Objects.requireNonNull(sortOrders, "sortOrders is null");
            Preconditions.checkArgument((sortChannels.size() == sortOrders.size() ? 1 : 0) != 0, (Object)"The number of sort channels must be equal to the number of sort orders");
            Preconditions.checkArgument((preSortedPrefix <= sortChannels.size() ? 1 : 0) != 0, (Object)"The number of pre-sorted channels must be lower or equal to the number of sort channels");
            Preconditions.checkArgument((preSortedPrefix == 0 || ImmutableSet.copyOf(prePartitionedChannels).equals((Object)ImmutableSet.copyOf(partitionChannels)) ? 1 : 0) != 0, (Object)"preSortedPrefix can only be greater than zero if all partition channels are pre-grouped");
            Objects.requireNonNull(sourceTypes, "sourceTypes is null");
            Objects.requireNonNull(pagesIndexFactory, "pagesIndexFactory is null");
            this.operatorId = operatorId;
            this.planNodeId = planNodeId;
            this.tableFunctionProvider = tableFunctionProvider;
            this.catalogHandle = catalogHandle;
            this.functionHandle = functionHandle;
            this.properChannelsCount = properChannelsCount;
            this.passThroughSourcesCount = passThroughSourcesCount;
            this.requiredChannels = (List)requiredChannels.stream().map(ImmutableList::copyOf).collect(ImmutableList.toImmutableList());
            this.markerChannels = markerChannels.map(ImmutableMap::copyOf);
            this.passThroughSpecifications = ImmutableList.copyOf(passThroughSpecifications);
            this.pruneWhenEmpty = pruneWhenEmpty;
            this.partitionChannels = ImmutableList.copyOf(partitionChannels);
            this.prePartitionedChannels = ImmutableList.copyOf(prePartitionedChannels);
            this.sortChannels = ImmutableList.copyOf(sortChannels);
            this.sortOrders = ImmutableList.copyOf(sortOrders);
            this.preSortedPrefix = preSortedPrefix;
            this.sourceTypes = ImmutableList.copyOf(sourceTypes);
            this.expectedPositions = expectedPositions;
            this.pagesIndexFactory = pagesIndexFactory;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, TableFunctionOperator.class.getSimpleName());
            return new TableFunctionOperator(operatorContext, this.tableFunctionProvider, this.catalogHandle, this.functionHandle, this.properChannelsCount, this.passThroughSourcesCount, this.requiredChannels, this.markerChannels, this.passThroughSpecifications, this.pruneWhenEmpty, this.partitionChannels, this.prePartitionedChannels, this.sortChannels, this.sortOrders, this.preSortedPrefix, this.sourceTypes, this.expectedPositions, this.pagesIndexFactory);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new TableFunctionOperatorFactory(this.operatorId, this.planNodeId, this.tableFunctionProvider, this.catalogHandle, this.functionHandle, this.properChannelsCount, this.passThroughSourcesCount, this.requiredChannels, this.markerChannels, this.passThroughSpecifications, this.pruneWhenEmpty, this.partitionChannels, this.prePartitionedChannels, this.sortChannels, this.sortOrders, this.preSortedPrefix, this.sourceTypes, this.expectedPositions, this.pagesIndexFactory);
        }
    }
}

