/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.join;

import com.google.common.base.Verify;
import com.google.common.primitives.Ints;
import io.trino.operator.join.LookupSource;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.type.BigintType;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.OptionalInt;

public class JoinProbe {
    private final int[] probeOutputChannels;
    private final int positionCount;
    private final Page page;
    private final Page probePage;
    @Nullable
    private final Block probeHashBlock;
    private final boolean probeMayHaveNull;
    private int position = -1;

    private JoinProbe(int[] probeOutputChannels, Page page, Page probePage, @Nullable Block probeHashBlock) {
        this.probeOutputChannels = probeOutputChannels;
        this.positionCount = page.getPositionCount();
        this.page = page;
        this.probePage = probePage;
        this.probeHashBlock = probeHashBlock;
        this.probeMayHaveNull = JoinProbe.probeMayHaveNull(probePage);
    }

    public int[] getOutputChannels() {
        return this.probeOutputChannels;
    }

    public boolean advanceNextPosition() {
        Verify.verify((++this.position <= this.positionCount ? 1 : 0) != 0, (String)"already finished", (Object[])new Object[0]);
        return !this.isFinished();
    }

    public boolean isFinished() {
        return this.position == this.positionCount;
    }

    public long getCurrentJoinPosition(LookupSource lookupSource) {
        if (this.probeMayHaveNull && this.currentRowContainsNull()) {
            return -1L;
        }
        if (this.probeHashBlock != null) {
            long rawHash = BigintType.BIGINT.getLong(this.probeHashBlock, this.position);
            return lookupSource.getJoinPosition(this.position, this.probePage, this.page, rawHash);
        }
        return lookupSource.getJoinPosition(this.position, this.probePage, this.page);
    }

    public int getPosition() {
        return this.position;
    }

    public Page getPage() {
        return this.page;
    }

    private boolean currentRowContainsNull() {
        for (int i = 0; i < this.probePage.getChannelCount(); ++i) {
            if (!this.probePage.getBlock(i).isNull(this.position)) continue;
            return true;
        }
        return false;
    }

    private static boolean probeMayHaveNull(Page probePage) {
        for (int i = 0; i < probePage.getChannelCount(); ++i) {
            if (!probePage.getBlock(i).mayHaveNull()) continue;
            return true;
        }
        return false;
    }

    public static class JoinProbeFactory {
        private final int[] probeOutputChannels;
        private final int[] probeJoinChannels;
        private final int probeHashChannel;

        public JoinProbeFactory(int[] probeOutputChannels, List<Integer> probeJoinChannels, OptionalInt probeHashChannel) {
            this.probeOutputChannels = probeOutputChannels;
            this.probeJoinChannels = Ints.toArray(probeJoinChannels);
            this.probeHashChannel = probeHashChannel.orElse(-1);
        }

        public JoinProbe createJoinProbe(Page page) {
            Page probePage = page.getColumns(this.probeJoinChannels);
            return new JoinProbe(this.probeOutputChannels, page, probePage, this.probeHashChannel >= 0 ? page.getBlock(this.probeHashChannel) : null);
        }
    }
}

