/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.join.unspilled;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.errorprone.annotations.ThreadSafe;
import io.trino.memory.context.CoarseGrainLocalMemoryContext;
import io.trino.operator.DriverContext;
import io.trino.operator.HashArraySizeSupplier;
import io.trino.operator.Operator;
import io.trino.operator.OperatorContext;
import io.trino.operator.OperatorFactory;
import io.trino.operator.PagesIndex;
import io.trino.operator.join.JoinBridgeManager;
import io.trino.operator.join.LookupSource;
import io.trino.operator.join.LookupSourceSupplier;
import io.trino.operator.join.unspilled.PartitionedLookupSourceFactory;
import io.trino.spi.Page;
import io.trino.sql.gen.JoinFilterFunctionCompiler;
import io.trino.sql.planner.plan.PlanNodeId;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

@ThreadSafe
public class HashBuilderOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final CoarseGrainLocalMemoryContext localUserMemoryContext;
    private final PartitionedLookupSourceFactory lookupSourceFactory;
    private final ListenableFuture<Void> lookupSourceFactoryDestroyed;
    private final int partitionIndex;
    private final List<Integer> outputChannels;
    private final List<Integer> hashChannels;
    private final OptionalInt preComputedHashChannel;
    private final Optional<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> filterFunctionFactory;
    private final Optional<Integer> sortChannel;
    private final List<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> searchFunctionFactories;
    private final HashArraySizeSupplier hashArraySizeSupplier;
    private State state = State.CONSUMING_INPUT;
    @Nullable
    private PagesIndex index;
    private Optional<ListenableFuture<Void>> lookupSourceNotNeeded = Optional.empty();
    @Nullable
    private LookupSourceSupplier lookupSourceSupplier;

    public HashBuilderOperator(OperatorContext operatorContext, PartitionedLookupSourceFactory lookupSourceFactory, int partitionIndex, List<Integer> outputChannels, List<Integer> hashChannels, OptionalInt preComputedHashChannel, Optional<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> filterFunctionFactory, Optional<Integer> sortChannel, List<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> searchFunctionFactories, int expectedPositions, PagesIndex.Factory pagesIndexFactory, HashArraySizeSupplier hashArraySizeSupplier) {
        this(operatorContext, lookupSourceFactory, partitionIndex, outputChannels, hashChannels, preComputedHashChannel, filterFunctionFactory, sortChannel, searchFunctionFactories, expectedPositions, pagesIndexFactory, hashArraySizeSupplier, 65536L);
    }

    @VisibleForTesting
    HashBuilderOperator(OperatorContext operatorContext, PartitionedLookupSourceFactory lookupSourceFactory, int partitionIndex, List<Integer> outputChannels, List<Integer> hashChannels, OptionalInt preComputedHashChannel, Optional<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> filterFunctionFactory, Optional<Integer> sortChannel, List<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> searchFunctionFactories, int expectedPositions, PagesIndex.Factory pagesIndexFactory, HashArraySizeSupplier hashArraySizeSupplier, long memorySyncThreshold) {
        Objects.requireNonNull(pagesIndexFactory, "pagesIndexFactory is null");
        this.operatorContext = operatorContext;
        this.partitionIndex = partitionIndex;
        this.filterFunctionFactory = filterFunctionFactory;
        this.sortChannel = sortChannel;
        this.searchFunctionFactories = searchFunctionFactories;
        this.localUserMemoryContext = new CoarseGrainLocalMemoryContext(operatorContext.localUserMemoryContext(), memorySyncThreshold);
        this.index = pagesIndexFactory.newPagesIndex(lookupSourceFactory.getTypes(), expectedPositions);
        this.lookupSourceFactory = lookupSourceFactory;
        this.lookupSourceFactoryDestroyed = lookupSourceFactory.isDestroyed();
        this.outputChannels = outputChannels;
        this.hashChannels = hashChannels;
        this.preComputedHashChannel = preComputedHashChannel;
        this.hashArraySizeSupplier = Objects.requireNonNull(hashArraySizeSupplier, "hashArraySizeSupplier is null");
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<Void> isBlocked() {
        return switch (this.state.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> NOT_BLOCKED;
            case 1 -> this.lookupSourceNotNeeded.orElseThrow(() -> new IllegalStateException("Lookup source built, but disposal future not set"));
            case 2 -> NOT_BLOCKED;
        };
    }

    @Override
    public boolean needsInput() {
        boolean stateNeedsInput = this.state == State.CONSUMING_INPUT;
        return stateNeedsInput && !this.lookupSourceFactoryDestroyed.isDone();
    }

    @Override
    public void addInput(Page page) {
        Objects.requireNonNull(page, "page is null");
        if (this.lookupSourceFactoryDestroyed.isDone()) {
            this.close();
            return;
        }
        Preconditions.checkState((this.state == State.CONSUMING_INPUT ? 1 : 0) != 0);
        this.updateIndex(page);
    }

    private void updateIndex(Page page) {
        Preconditions.checkState((this.index != null ? 1 : 0) != 0, (Object)"index is null");
        this.index.addPage(page);
        if (!this.localUserMemoryContext.trySetBytes(this.index.getEstimatedSize().toBytes())) {
            this.index.compact();
            this.localUserMemoryContext.setBytes(this.index.getEstimatedSize().toBytes());
        }
        this.operatorContext.recordOutput(page.getSizeInBytes(), page.getPositionCount());
    }

    @Override
    public Page getOutput() {
        return null;
    }

    @Override
    public void finish() {
        if (this.lookupSourceFactoryDestroyed.isDone()) {
            this.close();
            return;
        }
        switch (this.state.ordinal()) {
            case 0: {
                this.finishInput();
                return;
            }
            case 1: {
                this.disposeLookupSourceIfRequested();
                return;
            }
            case 2: {
                return;
            }
        }
        throw new IllegalStateException("Unhandled state: " + String.valueOf((Object)this.state));
    }

    private void finishInput() {
        Preconditions.checkState((this.state == State.CONSUMING_INPUT ? 1 : 0) != 0);
        if (this.lookupSourceFactoryDestroyed.isDone()) {
            this.close();
            return;
        }
        Preconditions.checkState((this.index != null ? 1 : 0) != 0, (Object)"index is null");
        ListenableFuture reserved = this.localUserMemoryContext.setBytes(this.index.getEstimatedMemoryRequiredToCreateLookupSource(this.hashArraySizeSupplier, this.sortChannel, this.hashChannels));
        if (!reserved.isDone()) {
            return;
        }
        LookupSourceSupplier partition = this.buildLookupSource();
        this.localUserMemoryContext.setBytes(((LookupSource)partition.get()).getInMemorySizeInBytes());
        this.lookupSourceNotNeeded = Optional.of(this.lookupSourceFactory.lendPartitionLookupSource(this.partitionIndex, partition));
        this.index = null;
        this.state = State.LOOKUP_SOURCE_BUILT;
    }

    private void disposeLookupSourceIfRequested() {
        Preconditions.checkState((this.state == State.LOOKUP_SOURCE_BUILT ? 1 : 0) != 0);
        Verify.verify((boolean)this.lookupSourceNotNeeded.isPresent());
        if (!this.lookupSourceNotNeeded.get().isDone()) {
            return;
        }
        this.close();
    }

    private LookupSourceSupplier buildLookupSource() {
        Preconditions.checkState((this.index != null ? 1 : 0) != 0, (Object)"index is null");
        LookupSourceSupplier partition = this.index.createLookupSourceSupplier(this.operatorContext.getSession(), this.hashChannels, this.preComputedHashChannel, this.filterFunctionFactory, this.sortChannel, this.searchFunctionFactories, Optional.of(this.outputChannels), this.hashArraySizeSupplier);
        Preconditions.checkState((this.lookupSourceSupplier == null ? 1 : 0) != 0, (Object)"lookupSourceSupplier is already set");
        this.lookupSourceSupplier = partition;
        return partition;
    }

    @Override
    public boolean isFinished() {
        if (this.lookupSourceFactoryDestroyed.isDone()) {
            this.close();
            return true;
        }
        return this.state == State.CLOSED;
    }

    @Override
    public void close() {
        if (this.state == State.CLOSED) {
            return;
        }
        this.lookupSourceSupplier = null;
        this.index = null;
        this.localUserMemoryContext.setBytes(0L);
        this.state = State.CLOSED;
    }

    @VisibleForTesting
    State getState() {
        return this.state;
    }

    @VisibleForTesting
    public static enum State {
        CONSUMING_INPUT,
        LOOKUP_SOURCE_BUILT,
        CLOSED;

    }

    public static class HashBuilderOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactoryManager;
        private final List<Integer> outputChannels;
        private final List<Integer> hashChannels;
        private final OptionalInt preComputedHashChannel;
        private final Optional<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> filterFunctionFactory;
        private final Optional<Integer> sortChannel;
        private final List<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> searchFunctionFactories;
        private final PagesIndex.Factory pagesIndexFactory;
        private final int expectedPositions;
        private final HashArraySizeSupplier hashArraySizeSupplier;
        private int partitionIndex;
        private boolean closed;

        public HashBuilderOperatorFactory(int operatorId, PlanNodeId planNodeId, JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactoryManager, List<Integer> outputChannels, List<Integer> hashChannels, OptionalInt preComputedHashChannel, Optional<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> filterFunctionFactory, Optional<Integer> sortChannel, List<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> searchFunctionFactories, int expectedPositions, PagesIndex.Factory pagesIndexFactory, HashArraySizeSupplier hashArraySizeSupplier) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            Objects.requireNonNull(sortChannel, "sortChannel cannot be null");
            Objects.requireNonNull(searchFunctionFactories, "searchFunctionFactories is null");
            Preconditions.checkArgument((sortChannel.isPresent() != searchFunctionFactories.isEmpty() ? 1 : 0) != 0, (Object)"both or none sortChannel and searchFunctionFactories must be set");
            this.lookupSourceFactoryManager = Objects.requireNonNull(lookupSourceFactoryManager, "lookupSourceFactoryManager is null");
            this.outputChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(outputChannels, "outputChannels is null"));
            this.hashChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(hashChannels, "hashChannels is null"));
            this.preComputedHashChannel = Objects.requireNonNull(preComputedHashChannel, "preComputedHashChannel is null");
            this.filterFunctionFactory = Objects.requireNonNull(filterFunctionFactory, "filterFunctionFactory is null");
            this.sortChannel = sortChannel;
            this.searchFunctionFactories = ImmutableList.copyOf(searchFunctionFactories);
            this.pagesIndexFactory = Objects.requireNonNull(pagesIndexFactory, "pagesIndexFactory is null");
            this.hashArraySizeSupplier = Objects.requireNonNull(hashArraySizeSupplier, "hashArraySizeSupplier is null");
            this.expectedPositions = expectedPositions;
        }

        @Override
        public HashBuilderOperator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, HashBuilderOperator.class.getSimpleName());
            PartitionedLookupSourceFactory lookupSourceFactory = this.lookupSourceFactoryManager.getJoinBridge();
            Verify.verify((this.partitionIndex < lookupSourceFactory.partitions() ? 1 : 0) != 0);
            ++this.partitionIndex;
            return new HashBuilderOperator(operatorContext, lookupSourceFactory, this.partitionIndex - 1, this.outputChannels, this.hashChannels, this.preComputedHashChannel, this.filterFunctionFactory, this.sortChannel, this.searchFunctionFactories, this.expectedPositions, this.pagesIndexFactory, this.hashArraySizeSupplier);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            throw new UnsupportedOperationException("Parallel hash build cannot be duplicated");
        }
    }
}

