/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.join.unspilled;

import com.google.common.io.Closer;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.trino.operator.OperatorInfo;
import io.trino.operator.ProcessorContext;
import io.trino.operator.WorkProcessor;
import io.trino.operator.WorkProcessorOperator;
import io.trino.operator.join.JoinStatisticsCounter;
import io.trino.operator.join.LookupJoinOperatorFactory;
import io.trino.operator.join.LookupSource;
import io.trino.operator.join.unspilled.JoinProbe;
import io.trino.operator.join.unspilled.PageJoiner;
import io.trino.operator.join.unspilled.PartitionedLookupSourceFactory;
import io.trino.spi.Page;
import io.trino.spi.type.Type;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;

public class LookupJoinOperator
implements WorkProcessorOperator {
    private final ListenableFuture<LookupSource> lookupSourceFuture;
    private final WorkProcessor<Page> pages;
    private final JoinStatisticsCounter statisticsCounter;
    private final Runnable afterClose;
    private final PageJoiner sourcePagesJoiner;
    private boolean closed;

    LookupJoinOperator(List<Type> buildOutputTypes, LookupJoinOperatorFactory.JoinType joinType, boolean outputSingleMatch, boolean waitForBuild, PartitionedLookupSourceFactory lookupSourceFactory, JoinProbe.JoinProbeFactory joinProbeFactory, Runnable afterClose, ProcessorContext processorContext, WorkProcessor<Page> sourcePages) {
        this.statisticsCounter = new JoinStatisticsCounter(joinType);
        this.lookupSourceFuture = lookupSourceFactory.createLookupSource();
        this.afterClose = Objects.requireNonNull(afterClose, "afterClose is null");
        this.sourcePagesJoiner = new PageJoiner(processorContext, buildOutputTypes, joinType, outputSingleMatch, joinProbeFactory, this.lookupSourceFuture, this.statisticsCounter);
        WorkProcessor<Page> pages = sourcePages.transform(this.sourcePagesJoiner);
        if (waitForBuild) {
            pages = pages.blocking(() -> Futures.transform(this.lookupSourceFuture, ignored -> null, (Executor)MoreExecutors.directExecutor()));
        }
        this.pages = pages;
    }

    @Override
    public WorkProcessor<Page> getOutputPages() {
        return this.pages;
    }

    @Override
    public Optional<OperatorInfo> getOperatorInfo() {
        return Optional.of(this.statisticsCounter.get());
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try (Closer closer = Closer.create();){
            closer.register(this.afterClose::run);
            closer.register((Closeable)this.sourcePagesJoiner);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

