/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.join.unspilled;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.trino.operator.join.JoinBridge;
import io.trino.operator.join.LookupSource;
import io.trino.operator.join.OuterLookupSource;
import io.trino.operator.join.OuterPositionIterator;
import io.trino.operator.join.TrackingLookupSourceSupplier;
import io.trino.operator.join.unspilled.PartitionedLookupSource;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Supplier;

public final class PartitionedLookupSourceFactory
implements JoinBridge {
    private final List<Type> types;
    private final List<Type> outputTypes;
    private final List<Type> hashChannelTypes;
    private final boolean outer;
    private final TypeOperators typeOperators;
    @GuardedBy(value="this")
    private final Supplier<LookupSource>[] partitions;
    private final SettableFuture<Void> partitionsNoLongerNeeded = SettableFuture.create();
    @GuardedBy(value="this")
    private final SettableFuture<Void> destroyed = SettableFuture.create();
    @GuardedBy(value="this")
    private int partitionsSet;
    @GuardedBy(value="this")
    private TrackingLookupSourceSupplier lookupSourceSupplier;
    @GuardedBy(value="this")
    private final List<SettableFuture<LookupSource>> lookupSourceFutures = new ArrayList<SettableFuture<LookupSource>>();

    public PartitionedLookupSourceFactory(List<Type> types, List<Type> outputTypes, List<Type> hashChannelTypes, int partitionCount, boolean outer, TypeOperators typeOperators) {
        Preconditions.checkArgument((Integer.bitCount(partitionCount) == 1 ? 1 : 0) != 0, (Object)"partitionCount must be a power of 2");
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        this.outputTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(outputTypes, "outputTypes is null"));
        this.hashChannelTypes = ImmutableList.copyOf(hashChannelTypes);
        Preconditions.checkArgument((partitionCount > 0 ? 1 : 0) != 0);
        this.partitions = new Supplier[partitionCount];
        this.outer = outer;
        this.typeOperators = typeOperators;
    }

    public List<Type> getTypes() {
        return this.types;
    }

    public List<Type> getOutputTypes() {
        return this.outputTypes;
    }

    public int partitions() {
        return this.partitions.length;
    }

    public synchronized ListenableFuture<LookupSource> createLookupSource() {
        Preconditions.checkState((!this.destroyed.isDone() ? 1 : 0) != 0, (Object)"already destroyed");
        if (this.lookupSourceSupplier != null) {
            return Futures.immediateFuture((Object)this.lookupSourceSupplier.getLookupSource());
        }
        SettableFuture lookupSourceFuture = SettableFuture.create();
        this.lookupSourceFutures.add((SettableFuture<LookupSource>)lookupSourceFuture);
        return lookupSourceFuture;
    }

    @Override
    public ListenableFuture<Void> whenBuildFinishes() {
        return Futures.transform(this.createLookupSource(), lookupSourceProvider -> {
            lookupSourceProvider.close();
            return null;
        }, (Executor)MoreExecutors.directExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<Void> lendPartitionLookupSource(int partitionIndex, Supplier<LookupSource> partitionLookupSource) {
        boolean completed;
        Objects.requireNonNull(partitionLookupSource, "partitionLookupSource is null");
        PartitionedLookupSourceFactory partitionedLookupSourceFactory = this;
        synchronized (partitionedLookupSourceFactory) {
            if (this.destroyed.isDone()) {
                return Futures.immediateVoidFuture();
            }
            Preconditions.checkState((this.partitions[partitionIndex] == null ? 1 : 0) != 0, (Object)"Partition already set");
            this.partitions[partitionIndex] = partitionLookupSource;
            ++this.partitionsSet;
            completed = this.partitionsSet == this.partitions.length;
        }
        if (completed) {
            this.supplyLookupSources();
        }
        return this.partitionsNoLongerNeeded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void supplyLookupSources() {
        ImmutableList lookupSourceFutures;
        TrackingLookupSourceSupplier lookupSourceSupplier;
        PartitionedLookupSourceFactory partitionedLookupSourceFactory = this;
        synchronized (partitionedLookupSourceFactory) {
            Preconditions.checkState((this.partitionsSet == this.partitions.length ? 1 : 0) != 0, (Object)"Not all set yet");
            Preconditions.checkState((this.lookupSourceSupplier == null ? 1 : 0) != 0, (Object)"Already supplied");
            if (this.partitionsNoLongerNeeded.isDone()) {
                return;
            }
            if (this.partitionsSet != 1) {
                ImmutableList partitions = ImmutableList.copyOf((Object[])this.partitions);
                lookupSourceSupplier = PartitionedLookupSource.createPartitionedLookupSourceSupplier((List<Supplier<LookupSource>>)partitions, this.hashChannelTypes, this.outer, this.typeOperators);
            } else {
                lookupSourceSupplier = this.outer ? OuterLookupSource.createOuterLookupSourceSupplier(this.partitions[0]) : TrackingLookupSourceSupplier.nonTracking(this.partitions[0]);
            }
            this.lookupSourceSupplier = lookupSourceSupplier;
            lookupSourceFutures = ImmutableList.copyOf(this.lookupSourceFutures);
        }
        for (SettableFuture lookupSourceFuture : lookupSourceFutures) {
            lookupSourceFuture.set((Object)lookupSourceSupplier.getLookupSource());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OuterPositionIterator getOuterPositionIterator() {
        TrackingLookupSourceSupplier lookupSourceSupplier;
        PartitionedLookupSourceFactory partitionedLookupSourceFactory = this;
        synchronized (partitionedLookupSourceFactory) {
            Preconditions.checkState((this.lookupSourceSupplier != null ? 1 : 0) != 0, (Object)"lookup source not ready yet");
            lookupSourceSupplier = this.lookupSourceSupplier;
        }
        return lookupSourceSupplier.getOuterPositionIterator();
    }

    @Override
    public synchronized void destroy() {
        this.freePartitions();
        this.destroyed.set(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void freePartitions() {
        this.partitionsNoLongerNeeded.set(null);
        PartitionedLookupSourceFactory partitionedLookupSourceFactory = this;
        synchronized (partitionedLookupSourceFactory) {
            Arrays.fill(this.partitions, null);
            this.lookupSourceSupplier = null;
        }
    }

    public ListenableFuture<Void> isDestroyed() {
        return Futures.nonCancellationPropagating(this.destroyed);
    }
}

