/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.function.Convention;
import io.trino.spi.function.Description;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorDependency;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlNullable;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.util.Failures;
import java.lang.invoke.MethodHandle;

@Description(value="Determines whether given value exists in the array")
@ScalarFunction(value="contains")
public final class ArrayContains {
    private ArrayContains() {
    }

    @TypeParameter(value="T")
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean contains(@OperatorDependency(operator=OperatorType.EQUAL, argumentTypes={"T", "T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}, result=InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN)) MethodHandle equals, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="T") Object value) {
        boolean foundNull = false;
        for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
            if (arrayBlock.isNull(i)) {
                foundNull = true;
                continue;
            }
            try {
                Boolean result = equals.invoke(arrayBlock, i, value);
                ArrayContains.checkNotIndeterminate(result);
                if (!result.booleanValue()) continue;
                return true;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        if (foundNull) {
            return null;
        }
        return false;
    }

    @TypeParameter(value="T")
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean contains(@OperatorDependency(operator=OperatorType.EQUAL, argumentTypes={"T", "T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}, result=InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN)) MethodHandle equals, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="T") long value) {
        boolean foundNull = false;
        for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
            if (arrayBlock.isNull(i)) {
                foundNull = true;
                continue;
            }
            try {
                Boolean result = equals.invokeExact(arrayBlock, i, value);
                ArrayContains.checkNotIndeterminate(result);
                if (!result.booleanValue()) continue;
                return true;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        if (foundNull) {
            return null;
        }
        return false;
    }

    @TypeParameter(value="T")
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean contains(@OperatorDependency(operator=OperatorType.EQUAL, argumentTypes={"T", "T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}, result=InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN)) MethodHandle equals, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="T") boolean value) {
        boolean foundNull = false;
        for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
            if (arrayBlock.isNull(i)) {
                foundNull = true;
                continue;
            }
            try {
                Boolean result = equals.invokeExact(arrayBlock, i, value);
                ArrayContains.checkNotIndeterminate(result);
                if (!result.booleanValue()) continue;
                return true;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        if (foundNull) {
            return null;
        }
        return false;
    }

    @TypeParameter(value="T")
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean contains(@OperatorDependency(operator=OperatorType.EQUAL, argumentTypes={"T", "T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}, result=InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN)) MethodHandle equals, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="T") double value) {
        boolean foundNull = false;
        for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
            if (arrayBlock.isNull(i)) {
                foundNull = true;
                continue;
            }
            try {
                Boolean result = equals.invokeExact(arrayBlock, i, value);
                ArrayContains.checkNotIndeterminate(result);
                if (!result.booleanValue()) continue;
                return true;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        if (foundNull) {
            return null;
        }
        return false;
    }

    private static void checkNotIndeterminate(Boolean equalsResult) {
        if (equalsResult == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "contains does not support arrays with elements that are null or contain null");
        }
    }
}

