/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.CastDependency;
import io.trino.spi.function.Convention;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.function.TypeParameters;
import io.trino.spi.type.Type;
import java.lang.invoke.MethodHandle;

@ScalarOperator(value=OperatorType.CAST)
public final class ArrayToArrayCast {
    private ArrayToArrayCast() {
    }

    @TypeParameters(value={@TypeParameter(value="F"), @TypeParameter(value="T")})
    @SqlType(value="array(T)")
    public static Block filter(@TypeParameter(value="T") Type resultType, @CastDependency(fromType="F", toType="T", convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL}, result=InvocationConvention.InvocationReturnConvention.BLOCK_BUILDER, session=true)) MethodHandle cast, ConnectorSession session, @SqlType(value="array(F)") Block array) throws Throwable {
        int positionCount = array.getPositionCount();
        BlockBuilder resultBuilder = resultType.createBlockBuilder(null, positionCount);
        for (int position = 0; position < positionCount; ++position) {
            if (array.isNull(position)) {
                resultBuilder.appendNull();
                continue;
            }
            cast.invokeExact(session, array, position, resultBuilder);
        }
        return resultBuilder.build();
    }
}

