/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.airlift.joni.Matcher;
import io.airlift.joni.Region;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceUtf8;
import io.trino.operator.scalar.JoniRegexpFunctions;
import io.trino.spi.block.Block;
import io.trino.spi.block.BufferedArrayValueBuilder;
import io.trino.spi.function.Description;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlNullable;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.gen.lambda.UnaryFunctionInterface;
import io.trino.type.JoniRegexp;

@ScalarFunction(value="regexp_replace")
@Description(value="Replaces substrings matching a regular expression using a lambda function")
public final class JoniRegexpReplaceLambdaFunction {
    private final BufferedArrayValueBuilder arrayValueBuilder = BufferedArrayValueBuilder.createBuffered((ArrayType)new ArrayType((Type)VarcharType.VARCHAR));

    @LiteralParameters(value={"x"})
    @SqlType(value="varchar")
    @SqlNullable
    public Slice regexpReplace(@SqlType(value="varchar") Slice source, @SqlType(value="JoniRegExp") JoniRegexp pattern, @SqlType(value="function(array(varchar), varchar(x))") UnaryFunctionInterface replaceFunction) {
        int nextStart;
        Matcher matcher = pattern.matcher(source.getBytes());
        if (JoniRegexpFunctions.getSearchingOffset(matcher, 0, source.length()) == -1) {
            return source;
        }
        DynamicSliceOutput output = new DynamicSliceOutput(source.length());
        int groupCount = pattern.regex().numberOfCaptures();
        int appendPosition = 0;
        do {
            nextStart = matcher.getEnd() == matcher.getBegin() ? (matcher.getBegin() < source.length() ? matcher.getEnd() + SliceUtf8.lengthOfCodePointFromStartByte((byte)source.getByte(matcher.getBegin())) : matcher.getEnd() + 1) : matcher.getEnd();
            Slice unmatched = source.slice(appendPosition, matcher.getBegin() - appendPosition);
            appendPosition = matcher.getEnd();
            output.appendBytes(unmatched);
            Region matchedRegion = matcher.getEagerRegion();
            Block target = this.arrayValueBuilder.build(groupCount, elementBuilder -> {
                for (int i = 1; i <= groupCount; ++i) {
                    if (matchedRegion.beg[i] >= 0 && matchedRegion.end[i] >= 0) {
                        VarcharType.VARCHAR.writeSlice(elementBuilder, source, matchedRegion.beg[i], matchedRegion.end[i] - matchedRegion.beg[i]);
                        continue;
                    }
                    elementBuilder.appendNull();
                }
            });
            Slice replaced = (Slice)replaceFunction.apply(target);
            if (replaced == null) {
                return null;
            }
            output.appendBytes(replaced);
        } while (JoniRegexpFunctions.getSearchingOffset(matcher, nextStart, source.length()) != -1);
        output.writeBytes(source, appendPosition, source.length() - appendPosition);
        return output.slice();
    }
}

