/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.trino.annotation.UsedByGeneratedCode;
import io.trino.metadata.SqlScalarFunction;
import io.trino.operator.scalar.ChoicesSpecializedSqlScalarFunction;
import io.trino.operator.scalar.JsonExtract;
import io.trino.operator.scalar.JsonPath;
import io.trino.operator.scalar.SpecializedSqlScalarFunction;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.ArrayBlockBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.Signature;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.VarcharType;
import io.trino.util.JsonCastException;
import io.trino.util.JsonUtil;
import io.trino.util.Reflection;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.util.List;

public final class JsonStringArrayExtractScalar
extends SqlScalarFunction {
    public static final JsonStringArrayExtractScalar JSON_STRING_ARRAY_EXTRACT_SCALAR = new JsonStringArrayExtractScalar();
    public static final String JSON_STRING_ARRAY_EXTRACT_SCALAR_NAME = "$internal$json_string_array_extract_scalar";
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(JsonStringArrayExtractScalar.class, "extract", Slice.class, JsonPath.class);
    private static final JsonFactory JSON_FACTORY = JsonUtil.createJsonFactory();
    private static final ArrayType ARRAY_TYPE = new ArrayType((Type)VarcharType.VARCHAR);

    private JsonStringArrayExtractScalar() {
        super(FunctionMetadata.scalarBuilder((String)JSON_STRING_ARRAY_EXTRACT_SCALAR_NAME).signature(Signature.builder().argumentType(new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"N")})).longVariable("N").argumentType(new TypeSignature("JsonPath", new TypeSignatureParameter[0])).returnType(TypeSignature.arrayType((TypeSignature)VarcharType.VARCHAR.getTypeSignature())).build()).nullable().hidden().noDescription().build());
    }

    @Override
    protected SpecializedSqlScalarFunction specialize(BoundSignature boundSignature) {
        return new ChoicesSpecializedSqlScalarFunction(boundSignature, InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, (List<InvocationConvention.InvocationArgumentConvention>)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL, (Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), METHOD_HANDLE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @UsedByGeneratedCode
    public static Block extract(Slice json, JsonPath jsonPath) {
        try (JsonParser jsonParser = JsonUtil.createJsonParser(JSON_FACTORY, json);){
            jsonParser.nextToken();
            if (jsonParser.getCurrentToken() == JsonToken.VALUE_NULL) {
                Block block2 = null;
                return block2;
            }
            ArrayBlockBuilder blockBuilder = ARRAY_TYPE.createBlockBuilder(null, 1);
            JsonStringArrayExtractScalar.append(jsonParser, jsonPath.getScalarExtractor(), (BlockBuilder)blockBuilder);
            Block block3 = blockBuilder.build();
            Block block = ARRAY_TYPE.getObject(block3, 0);
            return block;
        }
        catch (TrinoException | JsonCastException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast to %s. %s\n%s", ARRAY_TYPE, e.getMessage(), JsonUtil.truncateIfNecessaryForErrorMessage(json)), e);
        }
        catch (Exception e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast to %s.\n%s", ARRAY_TYPE, JsonUtil.truncateIfNecessaryForErrorMessage(json)), (Throwable)e);
        }
    }

    public static void append(JsonParser parser, JsonExtract.JsonExtractor<Slice> extractor, BlockBuilder blockBuilder) throws IOException {
        if (parser.getCurrentToken() == JsonToken.VALUE_NULL) {
            JsonStringArrayExtractScalar.append(null, blockBuilder);
            return;
        }
        if (parser.getCurrentToken() != JsonToken.START_ARRAY) {
            throw new JsonCastException(String.format("Expected a json array, but got %s", parser.getText()));
        }
        ((ArrayBlockBuilder)blockBuilder).buildEntry(elementBuilder -> {
            while (parser.nextToken() != JsonToken.END_ARRAY) {
                if (parser.getCurrentToken() == JsonToken.VALUE_NULL) {
                    JsonStringArrayExtractScalar.append(null, elementBuilder);
                    continue;
                }
                JsonParser jsonParser = parser.readValueAsTree().traverse();
                JsonStringArrayExtractScalar.append((Slice)JsonExtract.extract(jsonParser, extractor), elementBuilder);
            }
        });
    }

    private static void append(Slice slice, BlockBuilder blockBuilder) {
        if (slice == null) {
            blockBuilder.appendNull();
        } else {
            VarcharType.VARCHAR.writeSlice(blockBuilder, slice);
        }
    }

    static {
        new ObjectMapper(JSON_FACTORY);
    }
}

