/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.trino.annotation.UsedByGeneratedCode;
import io.trino.metadata.SqlScalarFunction;
import io.trino.operator.scalar.ChoicesSpecializedSqlScalarFunction;
import io.trino.operator.scalar.SpecializedSqlScalarFunction;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.ArrayBlockBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.Signature;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.type.JsonType;
import io.trino.util.Failures;
import io.trino.util.JsonCastException;
import io.trino.util.JsonUtil;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;

public class JsonToArrayCast
extends SqlScalarFunction {
    public static final JsonToArrayCast JSON_TO_ARRAY = new JsonToArrayCast();
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(JsonToArrayCast.class, "toArray", ArrayType.class, JsonUtil.BlockBuilderAppender.class, ConnectorSession.class, Slice.class);
    private static final JsonFactory JSON_FACTORY = JsonUtil.createJsonFactory();

    private JsonToArrayCast() {
        super(FunctionMetadata.operatorBuilder((OperatorType)OperatorType.CAST).signature(Signature.builder().castableFromTypeParameter("T", JsonType.JSON.getTypeSignature()).returnType(TypeSignature.arrayType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]))).argumentType((Type)JsonType.JSON).build()).nullable().build());
    }

    @Override
    protected SpecializedSqlScalarFunction specialize(BoundSignature boundSignature) {
        Preconditions.checkArgument((boundSignature.getArity() == 1 ? 1 : 0) != 0, (Object)"Expected arity to be 1");
        ArrayType arrayType = (ArrayType)boundSignature.getReturnType();
        Failures.checkCondition(JsonUtil.canCastFromJson((Type)arrayType), (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Cannot cast JSON to %s", arrayType);
        JsonUtil.BlockBuilderAppender arrayAppender = JsonUtil.BlockBuilderAppender.createBlockBuilderAppender((Type)arrayType);
        MethodHandle methodHandle = METHOD_HANDLE.bindTo(arrayType).bindTo(arrayAppender);
        return new ChoicesSpecializedSqlScalarFunction(boundSignature, InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, (List<InvocationConvention.InvocationArgumentConvention>)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), methodHandle);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @UsedByGeneratedCode
    public static Block toArray(ArrayType arrayType, JsonUtil.BlockBuilderAppender arrayAppender, ConnectorSession connectorSession, Slice json) {
        try (JsonParser jsonParser = JsonUtil.createJsonParser(JSON_FACTORY, json);){
            jsonParser.nextToken();
            if (jsonParser.getCurrentToken() == JsonToken.VALUE_NULL) {
                Block block2 = null;
                return block2;
            }
            ArrayBlockBuilder blockBuilder = arrayType.createBlockBuilder(null, 1);
            arrayAppender.append(jsonParser, (BlockBuilder)blockBuilder);
            if (jsonParser.nextToken() != null) {
                throw new JsonCastException(String.format("Unexpected trailing token: %s", jsonParser.getText()));
            }
            Block block3 = blockBuilder.build();
            Block block = arrayType.getObject(block3, 0);
            return block;
        }
        catch (TrinoException | JsonCastException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast to %s. %s\n%s", arrayType, e.getMessage(), JsonUtil.truncateIfNecessaryForErrorMessage(json)), e);
        }
        catch (Exception e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast to %s.\n%s", arrayType, JsonUtil.truncateIfNecessaryForErrorMessage(json)), (Throwable)e);
        }
    }

    static {
        new ObjectMapper(JSON_FACTORY);
    }
}

