/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.trino.metadata.SqlScalarFunction;
import io.trino.operator.scalar.ChoicesSpecializedSqlScalarFunction;
import io.trino.operator.scalar.SpecializedSqlScalarFunction;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BufferedMapValueBuilder;
import io.trino.spi.block.SqlMap;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.Signature;
import io.trino.spi.type.MapType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.TypeUtils;
import io.trino.sql.gen.lambda.LambdaFunctionInterface;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Optional;

public final class MapZipWithFunction
extends SqlScalarFunction {
    public static final MapZipWithFunction MAP_ZIP_WITH_FUNCTION = new MapZipWithFunction();
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(MapZipWithFunction.class, "mapZipWith", Type.class, Type.class, Type.class, MapType.class, Object.class, SqlMap.class, SqlMap.class, MapZipWithLambda.class);
    private static final MethodHandle STATE_FACTORY = Reflection.methodHandle(MapZipWithFunction.class, "createState", MapType.class);

    private MapZipWithFunction() {
        super(FunctionMetadata.scalarBuilder((String)"map_zip_with").signature(Signature.builder().typeVariable("K").typeVariable("V1").typeVariable("V2").typeVariable("V3").returnType(TypeSignature.mapType((TypeSignature)new TypeSignature("K", new TypeSignatureParameter[0]), (TypeSignature)new TypeSignature("V3", new TypeSignatureParameter[0]))).argumentType(TypeSignature.mapType((TypeSignature)new TypeSignature("K", new TypeSignatureParameter[0]), (TypeSignature)new TypeSignature("V1", new TypeSignatureParameter[0]))).argumentType(TypeSignature.mapType((TypeSignature)new TypeSignature("K", new TypeSignatureParameter[0]), (TypeSignature)new TypeSignature("V2", new TypeSignatureParameter[0]))).argumentType(TypeSignature.functionType((TypeSignature)new TypeSignature("K", new TypeSignatureParameter[0]), (TypeSignature[])new TypeSignature[]{new TypeSignature("V1", new TypeSignatureParameter[0]), new TypeSignature("V2", new TypeSignatureParameter[0]), new TypeSignature("V3", new TypeSignatureParameter[0])})).build()).description("Merge two maps into a single map by applying the lambda function to the pair of values with the same key").build());
    }

    @Override
    protected SpecializedSqlScalarFunction specialize(BoundSignature boundSignature) {
        MapType outputMapType = (MapType)boundSignature.getReturnType();
        Type keyType = outputMapType.getKeyType();
        Type inputValueType1 = ((MapType)boundSignature.getArgumentType(0)).getValueType();
        Type inputValueType2 = ((MapType)boundSignature.getArgumentType(1)).getValueType();
        return new ChoicesSpecializedSqlScalarFunction(boundSignature, InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (List<InvocationConvention.InvocationArgumentConvention>)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL, (Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL, (Object)InvocationConvention.InvocationArgumentConvention.FUNCTION), (List<Class<?>>)ImmutableList.of(MapZipWithLambda.class), METHOD_HANDLE.bindTo(keyType).bindTo(inputValueType1).bindTo(inputValueType2).bindTo(outputMapType), Optional.of(STATE_FACTORY.bindTo(outputMapType)));
    }

    public static Object createState(MapType mapType) {
        return BufferedMapValueBuilder.createBuffered((MapType)mapType);
    }

    public static SqlMap mapZipWith(Type keyType, Type leftValueType, Type rightValueType, MapType outputMapType, Object state, SqlMap leftMap, SqlMap rightMap, MapZipWithLambda function) {
        Type outputValueType = outputMapType.getValueType();
        int leftSize = leftMap.getSize();
        int leftRawOffset = leftMap.getRawOffset();
        Block leftRawKeyBlock = leftMap.getRawKeyBlock();
        Block leftRawValueBlock = leftMap.getRawValueBlock();
        int rightSize = rightMap.getSize();
        int rightRawOffset = rightMap.getRawOffset();
        Block rightRawKeyBlock = rightMap.getRawKeyBlock();
        Block rightRawValueBlock = rightMap.getRawValueBlock();
        int maxOutputSize = leftSize + rightSize;
        BufferedMapValueBuilder mapValueBuilder = (BufferedMapValueBuilder)state;
        return mapValueBuilder.build(maxOutputSize, (keyBuilder, valueBuilder) -> {
            Object key;
            boolean[] keyFound = new boolean[rightSize];
            for (int leftIndex = 0; leftIndex < leftSize; ++leftIndex) {
                key = TypeUtils.readNativeValue((Type)keyType, (Block)leftRawKeyBlock, (int)(leftRawOffset + leftIndex));
                Object leftValue = TypeUtils.readNativeValue((Type)leftValueType, (Block)leftRawValueBlock, (int)(leftRawOffset + leftIndex));
                int rightIndex = rightMap.seekKey(key);
                Object rightValue = null;
                if (rightIndex != -1) {
                    rightValue = TypeUtils.readNativeValue((Type)rightValueType, (Block)rightRawValueBlock, (int)(rightRawOffset + rightIndex));
                    keyFound[rightIndex] = true;
                }
                Object outputValue = function.apply(key, leftValue, rightValue);
                keyType.appendTo(leftRawKeyBlock, leftRawOffset + leftIndex, keyBuilder);
                TypeUtils.writeNativeValue((Type)outputValueType, (BlockBuilder)valueBuilder, (Object)outputValue);
            }
            for (int rightIndex = 0; rightIndex < rightSize; ++rightIndex) {
                if (keyFound[rightIndex]) continue;
                key = TypeUtils.readNativeValue((Type)keyType, (Block)rightRawKeyBlock, (int)(rightRawOffset + rightIndex));
                Object rightValue = TypeUtils.readNativeValue((Type)rightValueType, (Block)rightRawValueBlock, (int)(rightRawOffset + rightIndex));
                Object outputValue = function.apply(key, null, rightValue);
                keyType.appendTo(rightRawKeyBlock, rightRawOffset + rightIndex, keyBuilder);
                TypeUtils.writeNativeValue((Type)outputValueType, (BlockBuilder)valueBuilder, (Object)outputValue);
            }
        });
    }

    @FunctionalInterface
    public static interface MapZipWithLambda
    extends LambdaFunctionInterface {
        public Object apply(Object var1, Object var2, Object var3);
    }
}

