/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.operator.scalar.DateTimeFunctions;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.Description;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.FixedWidthType;
import io.trino.type.DateTimeOperators;
import io.trino.util.Failures;
import java.util.concurrent.TimeUnit;

public final class SequenceFunction {
    private static final long MAX_RESULT_ENTRIES = 10000L;
    private static final Slice MONTH = Slices.utf8Slice((String)"month");

    private SequenceFunction() {
    }

    @Description(value="Sequence function to generate synthetic arrays")
    @ScalarFunction(value="sequence")
    @SqlType(value="array(bigint)")
    public static Block sequence(@SqlType(value="bigint") long start, @SqlType(value="bigint") long stop, @SqlType(value="bigint") long step) {
        return SequenceFunction.fixedWidthSequence(start, stop, step, (FixedWidthType)BigintType.BIGINT);
    }

    @ScalarFunction(value="sequence")
    @SqlType(value="array(bigint)")
    public static Block sequenceDefaultStep(@SqlType(value="bigint") long start, @SqlType(value="bigint") long stop) {
        return SequenceFunction.fixedWidthSequence(start, stop, stop >= start ? 1L : -1L, (FixedWidthType)BigintType.BIGINT);
    }

    @ScalarFunction(value="sequence")
    @SqlType(value="array(date)")
    public static Block sequenceDateDefaultStep(@SqlType(value="date") long start, @SqlType(value="date") long stop) {
        return SequenceFunction.fixedWidthSequence(start, stop, stop >= start ? 1L : -1L, (FixedWidthType)DateType.DATE);
    }

    @ScalarFunction(value="sequence")
    @SqlType(value="array(date)")
    public static Block sequenceDateDayToSecond(@SqlType(value="date") long start, @SqlType(value="date") long stop, @SqlType(value="interval day to second") long step) {
        Failures.checkCondition(step % TimeUnit.DAYS.toMillis(1L) == 0L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "sequence step must be a day interval if start and end values are dates", new Object[0]);
        return SequenceFunction.fixedWidthSequence(start, stop, step / TimeUnit.DAYS.toMillis(1L), (FixedWidthType)DateType.DATE);
    }

    @ScalarFunction(value="sequence")
    @SqlType(value="array(date)")
    public static Block sequenceDateYearToMonth(@SqlType(value="date") long start, @SqlType(value="date") long stop, @SqlType(value="interval year to month") long step) {
        SequenceFunction.checkValidStep(start, stop, step);
        int length = SequenceFunction.checkMaxEntry(DateTimeFunctions.diffDate(MONTH, start, stop) / step + 1L);
        BlockBuilder blockBuilder = DateType.DATE.createFixedSizeBlockBuilder(length);
        long value = 0L;
        for (int i = 0; i < length; ++i) {
            DateType.DATE.writeLong(blockBuilder, DateTimeOperators.datePlusIntervalYearToMonth(start, value));
            value += step;
        }
        return blockBuilder.build();
    }

    private static Block fixedWidthSequence(long start, long stop, long step, FixedWidthType type) {
        SequenceFunction.checkValidStep(start, stop, step);
        int length = SequenceFunction.getLength(start, stop, step);
        BlockBuilder blockBuilder = type.createFixedSizeBlockBuilder(length);
        long i = 0L;
        long value = start;
        while (i < (long)length) {
            type.writeLong(blockBuilder, value);
            ++i;
            value += step;
        }
        return blockBuilder.build();
    }

    private static int getLength(long start, long stop, long step) {
        if (start > 0L && stop > 0L || start < 0L && stop < 0L) {
            int length = SequenceFunction.checkMaxEntry((stop - start) / step);
            return SequenceFunction.checkMaxEntry(length + 1);
        }
        if (step == -1L || step == 1L) {
            SequenceFunction.checkMaxEntry(start);
            SequenceFunction.checkMaxEntry(stop);
            return SequenceFunction.checkMaxEntry((stop - start) / step + 1L);
        }
        int startLength = Math.abs(SequenceFunction.checkMaxEntry(start / step));
        int stopLength = Math.abs(SequenceFunction.checkMaxEntry(stop / step));
        long startRemain = start % step;
        long stopRemain = stop % step;
        int remainLength = step > 0L ? (startRemain + step <= stopRemain ? 2 : 1) : (startRemain + step >= stopRemain ? 2 : 1);
        return SequenceFunction.checkMaxEntry(startLength + stopLength + remainLength);
    }

    public static void checkValidStep(long start, long stop, long step) {
        Failures.checkCondition(step != 0L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "step must not be zero", new Object[0]);
        Failures.checkCondition(step > 0L ? stop >= start : stop <= start, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "sequence stop value should be greater than or equal to start value if step is greater than zero otherwise stop should be less than or equal to start", new Object[0]);
    }

    public static int checkMaxEntry(long length) {
        Failures.checkCondition(-10000L <= length && length <= 10000L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "result of sequence function must not have more than %d entries", 10000L);
        return Math.toIntExact(length);
    }
}

