/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.time;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.function.Constraint;
import io.trino.spi.function.LiteralParameter;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.function.SqlType;
import io.trino.type.DateTimes;

public final class TimeOperators {
    private TimeOperators() {
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @LiteralParameters(value={"p"})
    @SqlType(value="interval day to second")
    public static long subtract(@SqlType(value="time(p)") long left, @SqlType(value="time(p)") long right) {
        long interval = left - right;
        interval = DateTimes.rescaleWithRounding(interval, 12, 3);
        return interval;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @LiteralParameters(value={"x", "p"})
    @SqlType(value="time(p)")
    public static long castFromVarchar(@LiteralParameter(value="p") long precision, @SqlType(value="varchar(x)") Slice value) {
        try {
            long picos = DateTimes.parseTime(value.toStringUtf8());
            return DateTimes.round(picos, (int)(12L - precision)) % 86400000000000000L;
        }
        catch (IllegalArgumentException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Value cannot be cast to time: " + value.toStringUtf8(), (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.CAST)
    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="time(targetPrecision)")
    public static long castToTime(@LiteralParameter(value="sourcePrecision") long sourcePrecision, @LiteralParameter(value="targetPrecision") long targetPrecision, @SqlType(value="time(sourcePrecision)") long time) {
        if (sourcePrecision <= targetPrecision) {
            return time;
        }
        return DateTimes.round(time, (int)(12L - targetPrecision)) % 86400000000000000L;
    }

    @ScalarOperator(value=OperatorType.ADD)
    @LiteralParameters(value={"p", "u"})
    @SqlType(value="time(u)")
    @Constraint(variable="u", expression="max(3, p)")
    public static long timePlusIntervalDayToSecond(@SqlType(value="time(p)") long time, @SqlType(value="interval day to second") long interval) {
        return TimeOperators.add(time, interval * 1000000000L);
    }

    @ScalarOperator(value=OperatorType.ADD)
    @LiteralParameters(value={"p", "u"})
    @SqlType(value="time(u)")
    @Constraint(variable="u", expression="max(3, p)")
    public static long intervalDayToSecondPlusTime(@SqlType(value="interval day to second") long interval, @SqlType(value="time(p)") long time) {
        return TimeOperators.timePlusIntervalDayToSecond(time, interval);
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @LiteralParameters(value={"p", "u"})
    @SqlType(value="time(u)")
    @Constraint(variable="u", expression="max(3, p)")
    public static long timeMinusIntervalDayToSecond(@SqlType(value="time(p)") long time, @SqlType(value="interval day to second") long interval) {
        return TimeOperators.add(time, -interval * 1000000000L);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @LiteralParameters(value={"x", "p"})
    @SqlType(value="varchar(x)")
    public static Slice castToVarchar(@LiteralParameter(value="p") long precision, @SqlType(value="time(p)") long value) {
        if (precision < 0L || precision > 12L) {
            throw new IllegalArgumentException("Invalid precision: " + precision);
        }
        int precisionInt = (int)precision;
        int size = 8 + (precisionInt > 0 ? 1 : 0) + precisionInt;
        int hours = (int)(value / 3600000000000000L);
        int minutes = (int)(value / 60000000000000L % 60L);
        int seconds = (int)(value / 1000000000000L % 60L);
        byte[] bytes = new byte[size];
        TimeOperators.appendTwoDecimalDigits(0, bytes, hours);
        bytes[2] = 58;
        TimeOperators.appendTwoDecimalDigits(3, bytes, minutes);
        bytes[5] = 58;
        TimeOperators.appendTwoDecimalDigits(6, bytes, seconds);
        if (precisionInt > 0) {
            long scaledFraction = value % 1000000000000L / DateTimes.scaleFactor(precisionInt, 12);
            bytes[8] = 46;
            for (int index = 8 + precisionInt; index > 8; --index) {
                long temp = scaledFraction / 10L;
                int digit = (int)(scaledFraction - temp * 10L);
                scaledFraction = temp;
                bytes[index] = (byte)(48 + digit);
            }
        }
        return Slices.wrappedBuffer((byte[])bytes);
    }

    private static void appendTwoDecimalDigits(int index, byte[] bytes, int value) {
        int tens = value / 10;
        int ones = value - tens * 10;
        bytes[index] = (byte)(48 + tens);
        bytes[index + 1] = (byte)(48 + ones);
    }

    public static long add(long picos, long delta) {
        long result = (picos + delta) % 86400000000000000L;
        if (result < 0L) {
            result += 86400000000000000L;
        }
        return result;
    }
}

