/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timestamp;

import io.trino.operator.scalar.QuarterOfYearDateTimeField;
import io.trino.spi.function.Description;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.LongTimestamp;
import io.trino.type.DateTimes;
import org.joda.time.Chronology;
import org.joda.time.chrono.ISOChronology;

@Description(value="Quarter of the year of the given timestamp")
@ScalarFunction(value="quarter")
public final class ExtractQuarter {
    private ExtractQuarter() {
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="bigint")
    public static long extract(@SqlType(value="timestamp(p)") long timestamp) {
        return QuarterOfYearDateTimeField.QUARTER_OF_YEAR.getField((Chronology)ISOChronology.getInstanceUTC()).get(DateTimes.scaleEpochMicrosToMillis(timestamp));
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="bigint")
    public static long extract(@SqlType(value="timestamp(p)") LongTimestamp timestamp) {
        return ExtractQuarter.extract(timestamp.getEpochMicros());
    }
}

