/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timestamptz;

import io.trino.spi.function.Description;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.TimeZoneKey;
import io.trino.util.DateTimeZoneIndex;

@Description(value="Day of the year of the given timestamp")
@ScalarFunction(value="day_of_year", alias={"doy"})
public final class ExtractDayOfYear {
    private ExtractDayOfYear() {
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="bigint")
    public static long extract(@SqlType(value="timestamp(p) with time zone") long packedEpochMillis) {
        return DateTimeZoneIndex.unpackChronology(packedEpochMillis).dayOfYear().get(DateTimeEncoding.unpackMillisUtc((long)packedEpochMillis));
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="bigint")
    public static long extract(@SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone timestamp) {
        return DateTimeZoneIndex.getChronology(TimeZoneKey.getTimeZoneKey((short)timestamp.getTimeZoneKey())).dayOfYear().get(timestamp.getEpochMillis());
    }
}

