/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timetz;

import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.trino.operator.scalar.StringFunctions;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.LiteralParameter;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.LongTimeWithTimeZone;
import io.trino.type.DateTimes;
import java.util.regex.Matcher;

@ScalarOperator(value=OperatorType.CAST)
public final class VarcharToTimeWithTimeZoneCast {
    private VarcharToTimeWithTimeZoneCast() {
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="time(p) with time zone")
    public static long castToShort(@LiteralParameter(value="p") long precision, ConnectorSession session, @SqlType(value="varchar(x)") Slice value) {
        Preconditions.checkArgument(((int)precision <= 9 ? 1 : 0) != 0, (Object)"precision must be less than max short time with time zone precision");
        Matcher matcher = DateTimes.TIME_PATTERN.matcher(StringFunctions.trim(value).toStringUtf8());
        if (!matcher.matches()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Value cannot be cast to time with time zone: " + value.toStringUtf8());
        }
        try {
            long nanos = (long)VarcharToTimeWithTimeZoneCast.parseTime(matcher) * 1000000000L + VarcharToTimeWithTimeZoneCast.parseFraction((int)precision, matcher, 9);
            int offsetMinutes = VarcharToTimeWithTimeZoneCast.parseOffset(session, matcher);
            return DateTimeEncoding.packTimeWithTimeZone((long)(nanos %= 86400000000000L), (int)offsetMinutes);
        }
        catch (IllegalArgumentException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Value cannot be cast to time with time zone: " + value.toStringUtf8(), (Throwable)e);
        }
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="time(p) with time zone")
    public static LongTimeWithTimeZone castToLong(@LiteralParameter(value="p") long precision, ConnectorSession session, @SqlType(value="varchar(x)") Slice value) {
        Preconditions.checkArgument(((int)precision > 9 && (int)precision <= 12 ? 1 : 0) != 0, (Object)"precision out of range");
        Matcher matcher = DateTimes.TIME_PATTERN.matcher(StringFunctions.trim(value).toStringUtf8());
        if (!matcher.matches()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Value cannot be cast to time with time zone: " + value.toStringUtf8());
        }
        try {
            long picos = (long)VarcharToTimeWithTimeZoneCast.parseTime(matcher) * 1000000000000L + VarcharToTimeWithTimeZoneCast.parseFraction((int)precision, matcher, 12);
            int offsetMinutes = VarcharToTimeWithTimeZoneCast.parseOffset(session, matcher);
            return new LongTimeWithTimeZone(picos %= 86400000000000000L, offsetMinutes);
        }
        catch (IllegalArgumentException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Value cannot be cast to time with time zone: " + value.toStringUtf8(), (Throwable)e);
        }
    }

    private static int parseTime(Matcher matcher) {
        int second;
        int hour = Integer.parseInt(matcher.group("hour"));
        int minute = Integer.parseInt(matcher.group("minute"));
        int n = second = matcher.group("second") == null ? 0 : Integer.parseInt(matcher.group("second"));
        if (hour > 23 || minute > 59 || second > 59) {
            throw new IllegalArgumentException("Invalid time");
        }
        return (hour * 60 + minute) * 60 + second;
    }

    private static int parseOffset(ConnectorSession session, Matcher matcher) {
        if (matcher.group("offsetHour") != null && matcher.group("offsetMinute") != null) {
            int offsetMinute;
            int offsetSign = matcher.group("sign").equals("+") ? 1 : -1;
            int offsetHour = Integer.parseInt(matcher.group("offsetHour"));
            if (!DateTimes.isValidOffset(offsetHour, offsetMinute = Integer.parseInt(matcher.group("offsetMinute")))) {
                throw new IllegalArgumentException("Invalid time");
            }
            return DateTimes.calculateOffsetMinutes(offsetSign, offsetHour, offsetMinute);
        }
        return DateTimes.getOffsetMinutes(session.getStart(), session.getTimeZoneKey());
    }

    private static long parseFraction(int precision, Matcher matcher, int targetMagnitude) {
        String fraction = matcher.group("fraction");
        int actualPrecision = 0;
        long fractionValue = 0L;
        if (fraction != null) {
            actualPrecision = fraction.length();
            fractionValue = Long.parseLong(fraction);
        }
        if (actualPrecision > 12) {
            throw new IllegalArgumentException("Invalid time");
        }
        if (actualPrecision > precision) {
            fractionValue = DateTimes.round(fractionValue, actualPrecision - precision);
        }
        return DateTimes.rescale(fractionValue, actualPrecision, targetMagnitude);
    }
}

