/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.table;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.function.table.AbstractConnectorTableFunction;
import io.trino.spi.function.table.Argument;
import io.trino.spi.function.table.ConnectorTableFunctionHandle;
import io.trino.spi.function.table.Descriptor;
import io.trino.spi.function.table.DescriptorArgument;
import io.trino.spi.function.table.DescriptorArgumentSpecification;
import io.trino.spi.function.table.ReturnTypeSpecification;
import io.trino.spi.function.table.TableArgument;
import io.trino.spi.function.table.TableArgumentSpecification;
import io.trino.spi.function.table.TableFunctionAnalysis;
import io.trino.spi.function.table.TableFunctionDataProcessor;
import io.trino.spi.function.table.TableFunctionProcessorProvider;
import io.trino.spi.function.table.TableFunctionProcessorState;
import io.trino.spi.type.RowType;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class ExcludeColumnsFunction
extends AbstractConnectorTableFunction {
    public static final String NAME = "exclude_columns";
    private static final String TABLE_ARGUMENT_NAME = "INPUT";
    private static final String DESCRIPTOR_ARGUMENT_NAME = "COLUMNS";

    public ExcludeColumnsFunction() {
        super("builtin", NAME, (List)ImmutableList.of((Object)TableArgumentSpecification.builder().name(TABLE_ARGUMENT_NAME).rowSemantics().build(), (Object)DescriptorArgumentSpecification.builder().name(DESCRIPTOR_ARGUMENT_NAME).build()), (ReturnTypeSpecification)ReturnTypeSpecification.GenericTable.GENERIC_TABLE);
    }

    public TableFunctionAnalysis analyze(ConnectorSession session, ConnectorTransactionHandle transaction, Map<String, Argument> arguments, ConnectorAccessControl accessControl) {
        DescriptorArgument excludedColumns = (DescriptorArgument)arguments.get(DESCRIPTOR_ARGUMENT_NAME);
        if (excludedColumns.equals((Object)DescriptorArgument.NULL_DESCRIPTOR)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "COLUMNS descriptor is null");
        }
        Descriptor excludedColumnsDescriptor = (Descriptor)excludedColumns.getDescriptor().orElseThrow();
        if (excludedColumnsDescriptor.getFields().stream().anyMatch(field -> field.getType().isPresent())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "COLUMNS descriptor contains types");
        }
        Set excludedNames = (Set)excludedColumnsDescriptor.getFields().stream().map(Descriptor.Field::getName).map(name -> ((String)name.orElseThrow()).toLowerCase(Locale.ENGLISH)).collect(ImmutableSet.toImmutableSet());
        List inputSchema = ((TableArgument)arguments.get(TABLE_ARGUMENT_NAME)).getRowType().getFields();
        Set inputNames = (Set)inputSchema.stream().map(RowType.Field::getName).filter(Optional::isPresent).map(Optional::get).map(name -> name.toLowerCase(Locale.ENGLISH)).collect(ImmutableSet.toImmutableSet());
        if (!inputNames.containsAll(excludedNames)) {
            String missingColumns = Sets.difference((Set)excludedNames, (Set)inputNames).stream().collect(Collectors.joining(", ", "[", "]"));
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Excluded columns: %s not present in the table", missingColumns));
        }
        ImmutableList.Builder requiredColumns = ImmutableList.builder();
        ImmutableList.Builder returnedColumns = ImmutableList.builder();
        for (int i = 0; i < inputSchema.size(); ++i) {
            Optional name2 = ((RowType.Field)inputSchema.get(i)).getName();
            if (!name2.isEmpty() && excludedNames.contains(((String)name2.orElseThrow()).toLowerCase(Locale.ENGLISH))) continue;
            requiredColumns.add((Object)i);
            returnedColumns.add((Object)new Descriptor.Field(name2, Optional.of(((RowType.Field)inputSchema.get(i)).getType())));
        }
        ImmutableList returnedType = returnedColumns.build();
        if (returnedType.isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "All columns are excluded");
        }
        return TableFunctionAnalysis.builder().requiredColumns(TABLE_ARGUMENT_NAME, (List)requiredColumns.build()).returnedType(new Descriptor((List)returnedType)).handle((ConnectorTableFunctionHandle)new ExcludeColumnsFunctionHandle()).build();
    }

    public static TableFunctionProcessorProvider getExcludeColumnsFunctionProcessorProvider() {
        return new TableFunctionProcessorProvider(){

            public TableFunctionDataProcessor getDataProcessor(ConnectorSession session, ConnectorTableFunctionHandle handle) {
                return input -> {
                    if (input == null) {
                        return TableFunctionProcessorState.Finished.FINISHED;
                    }
                    return TableFunctionProcessorState.Processed.usedInputAndProduced((Page)((Page)((Optional)Iterables.getOnlyElement((Iterable)input)).orElseThrow()));
                };
            }
        };
    }

    public record ExcludeColumnsFunctionHandle() implements ConnectorTableFunctionHandle
    {
    }
}

