/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.window;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.trino.operator.PagesIndex;
import io.trino.operator.window.InternalWindowIndex;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import java.util.Objects;

public class PagesWindowIndex
implements InternalWindowIndex {
    private final PagesIndex pagesIndex;
    private final int start;
    private final int size;

    public PagesWindowIndex(PagesIndex pagesIndex, int start, int end) {
        Objects.requireNonNull(pagesIndex, "pagesIndex is null");
        Preconditions.checkPositionIndex((int)start, (int)pagesIndex.getPositionCount(), (String)"start");
        Preconditions.checkPositionIndex((int)end, (int)pagesIndex.getPositionCount(), (String)"end");
        Preconditions.checkArgument((start < end ? 1 : 0) != 0, (Object)"start must be before end");
        this.pagesIndex = pagesIndex;
        this.start = start;
        this.size = end - start;
    }

    public int size() {
        return this.size;
    }

    public boolean isNull(int channel, int position) {
        return this.pagesIndex.isNull(channel, this.position(position));
    }

    public boolean getBoolean(int channel, int position) {
        return this.pagesIndex.getBoolean(channel, this.position(position));
    }

    public long getLong(int channel, int position) {
        return this.pagesIndex.getLong(channel, this.position(position));
    }

    public double getDouble(int channel, int position) {
        return this.pagesIndex.getDouble(channel, this.position(position));
    }

    public Slice getSlice(int channel, int position) {
        return this.pagesIndex.getSlice(channel, this.position(position));
    }

    public Block getSingleValueBlock(int channel, int position) {
        return this.pagesIndex.getSingleValueBlock(channel, this.position(position));
    }

    public Object getObject(int channel, int position) {
        return this.pagesIndex.getObject(channel, this.position(position));
    }

    public void appendTo(int channel, int position, BlockBuilder output) {
        this.pagesIndex.appendTo(channel, this.position(position), output);
    }

    @Override
    public Block getRawBlock(int channel, int position) {
        return this.pagesIndex.getRawBlock(channel, this.position(position));
    }

    @Override
    public int getRawBlockPosition(int position) {
        return this.pagesIndex.getRawBlockPosition(this.position(position));
    }

    private int position(int position) {
        Preconditions.checkElementIndex((int)position, (int)this.size, (String)"position");
        return position + this.start;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("size", this.size).toString();
    }
}

