/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.window;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.operator.window.ReflectionWindowFunctionSupplier;
import io.trino.operator.window.SqlWindowFunction;
import io.trino.spi.function.Description;
import io.trino.spi.function.Signature;
import io.trino.spi.function.WindowFunction;
import io.trino.spi.function.WindowFunctionSignature;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public final class WindowAnnotationsParser {
    private WindowAnnotationsParser() {
    }

    public static List<SqlWindowFunction> parseFunctionDefinition(Class<? extends WindowFunction> clazz) {
        WindowFunctionSignature[] signatures = (WindowFunctionSignature[])clazz.getAnnotationsByType(WindowFunctionSignature.class);
        Preconditions.checkArgument((signatures.length > 0 ? 1 : 0) != 0, (String)"Class is not annotated with @WindowFunctionSignature: %s", (Object)clazz.getName());
        return (List)Stream.of(signatures).map(signature -> WindowAnnotationsParser.parse(clazz, signature)).collect(ImmutableList.toImmutableList());
    }

    private static SqlWindowFunction parse(Class<? extends WindowFunction> clazz, WindowFunctionSignature window) {
        Signature.Builder signatureBuilder = Signature.builder();
        if (!window.typeVariable().isEmpty()) {
            signatureBuilder.typeVariable(window.typeVariable());
        }
        Stream.of(window.argumentTypes()).map(type -> TypeSignatureTranslator.parseTypeSignature(type, (Set<String>)ImmutableSet.of())).forEach(arg_0 -> ((Signature.Builder)signatureBuilder).argumentType(arg_0));
        signatureBuilder.returnType(TypeSignatureTranslator.parseTypeSignature(window.returnType(), (Set<String>)ImmutableSet.of()));
        Optional<String> description = Optional.ofNullable(clazz.getAnnotation(Description.class)).map(Description::value);
        boolean deprecated = ((Deprecated[])clazz.getAnnotationsByType(Deprecated.class)).length > 0;
        return new SqlWindowFunction(window.name(), signatureBuilder.build(), description, deprecated, new ReflectionWindowFunctionSupplier(window.argumentTypes().length, clazz));
    }
}

