/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.window.matcher;

import io.airlift.slice.SizeOf;
import java.util.Arrays;

class IntStack {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(IntStack.class);
    private int[] values;
    private int next;

    public IntStack(int capacity) {
        this.values = new int[capacity];
    }

    public void push(int value) {
        this.ensureCapacity();
        this.values[this.next] = value;
        ++this.next;
    }

    public int pop() {
        --this.next;
        return this.values[this.next];
    }

    public int size() {
        return this.next;
    }

    private void ensureCapacity() {
        if (this.next == this.values.length) {
            this.values = Arrays.copyOf(this.values, this.next * 2 + 1);
        }
    }

    public long getSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((int[])this.values);
    }
}

