/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.execution.QueryStats;
import io.trino.operator.BlockedReason;
import java.util.Collection;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;

@Immutable
public class BasicQueryStats {
    private final DateTime createTime;
    private final DateTime endTime;
    private final Duration queuedTime;
    private final Duration elapsedTime;
    private final Duration executionTime;
    private final int failedTasks;
    private final int totalDrivers;
    private final int queuedDrivers;
    private final int runningDrivers;
    private final int completedDrivers;
    private final int blockedDrivers;
    private final DataSize rawInputDataSize;
    private final long rawInputPositions;
    private final DataSize spilledDataSize;
    private final DataSize physicalInputDataSize;
    private final DataSize physicalWrittenDataSize;
    private final DataSize internalNetworkInputDataSize;
    private final double cumulativeUserMemory;
    private final double failedCumulativeUserMemory;
    private final DataSize userMemoryReservation;
    private final DataSize totalMemoryReservation;
    private final DataSize peakUserMemoryReservation;
    private final DataSize peakTotalMemoryReservation;
    private final Duration planningTime;
    private final Duration analysisTime;
    private final Duration totalCpuTime;
    private final Duration failedCpuTime;
    private final Duration totalScheduledTime;
    private final Duration failedScheduledTime;
    private final Duration finishingTime;
    private final Duration physicalInputReadTime;
    private final boolean fullyBlocked;
    private final Set<BlockedReason> blockedReasons;
    private final OptionalDouble progressPercentage;
    private final OptionalDouble runningPercentage;

    @JsonCreator
    public BasicQueryStats(@JsonProperty(value="createTime") DateTime createTime, @JsonProperty(value="endTime") DateTime endTime, @JsonProperty(value="queuedTime") Duration queuedTime, @JsonProperty(value="elapsedTime") Duration elapsedTime, @JsonProperty(value="executionTime") Duration executionTime, @JsonProperty(value="failedTasks") int failedTasks, @JsonProperty(value="totalDrivers") int totalDrivers, @JsonProperty(value="queuedDrivers") int queuedDrivers, @JsonProperty(value="runningDrivers") int runningDrivers, @JsonProperty(value="completedDrivers") int completedDrivers, @JsonProperty(value="blockedDrivers") int blockedDrivers, @JsonProperty(value="rawInputDataSize") DataSize rawInputDataSize, @JsonProperty(value="rawInputPositions") long rawInputPositions, @JsonProperty(value="spilledDataSize") DataSize spilledDataSize, @JsonProperty(value="physicalInputDataSize") DataSize physicalInputDataSize, @JsonProperty(value="physicalWrittenDataSize") DataSize physicalWrittenDataSize, @JsonProperty(value="internalNetworkInputDataSize") DataSize internalNetworkInputDataSize, @JsonProperty(value="cumulativeUserMemory") double cumulativeUserMemory, @JsonProperty(value="failedCumulativeUserMemory") double failedCumulativeUserMemory, @JsonProperty(value="userMemoryReservation") DataSize userMemoryReservation, @JsonProperty(value="totalMemoryReservation") DataSize totalMemoryReservation, @JsonProperty(value="peakUserMemoryReservation") DataSize peakUserMemoryReservation, @JsonProperty(value="peakTotalMemoryReservation") DataSize peakTotalMemoryReservation, @JsonProperty(value="planningTime") Duration planningTime, @JsonProperty(value="analysisTime") Duration analysisTime, @JsonProperty(value="totalCpuTime") Duration totalCpuTime, @JsonProperty(value="failedCpuTime") Duration failedCpuTime, @JsonProperty(value="totalScheduledTime") Duration totalScheduledTime, @JsonProperty(value="failedScheduledTime") Duration failedScheduledTime, @JsonProperty(value="finishingTime") Duration finishingTime, @JsonProperty(value="physicalInputReadTime") Duration physicalInputReadTime, @JsonProperty(value="fullyBlocked") boolean fullyBlocked, @JsonProperty(value="blockedReasons") Set<BlockedReason> blockedReasons, @JsonProperty(value="progressPercentage") OptionalDouble progressPercentage, @JsonProperty(value="runningPercentage") OptionalDouble runningPercentage) {
        this.createTime = createTime;
        this.endTime = endTime;
        this.queuedTime = Objects.requireNonNull(queuedTime, "queuedTime is null");
        this.elapsedTime = Objects.requireNonNull(elapsedTime, "elapsedTime is null");
        this.executionTime = Objects.requireNonNull(executionTime, "executionTime is null");
        Preconditions.checkArgument((failedTasks >= 0 ? 1 : 0) != 0, (Object)"failedTasks is negative");
        this.failedTasks = failedTasks;
        Preconditions.checkArgument((totalDrivers >= 0 ? 1 : 0) != 0, (Object)"totalDrivers is negative");
        this.totalDrivers = totalDrivers;
        Preconditions.checkArgument((queuedDrivers >= 0 ? 1 : 0) != 0, (Object)"queuedDrivers is negative");
        this.queuedDrivers = queuedDrivers;
        Preconditions.checkArgument((runningDrivers >= 0 ? 1 : 0) != 0, (Object)"runningDrivers is negative");
        this.runningDrivers = runningDrivers;
        Preconditions.checkArgument((completedDrivers >= 0 ? 1 : 0) != 0, (Object)"completedDrivers is negative");
        this.completedDrivers = completedDrivers;
        Preconditions.checkArgument((blockedDrivers >= 0 ? 1 : 0) != 0, (Object)"blockedDrivers is negative");
        this.blockedDrivers = blockedDrivers;
        this.rawInputDataSize = Objects.requireNonNull(rawInputDataSize, "rawInputDataSize is null");
        this.rawInputPositions = rawInputPositions;
        this.spilledDataSize = spilledDataSize;
        this.physicalInputDataSize = physicalInputDataSize;
        this.physicalWrittenDataSize = physicalWrittenDataSize;
        this.internalNetworkInputDataSize = internalNetworkInputDataSize;
        this.cumulativeUserMemory = cumulativeUserMemory;
        this.failedCumulativeUserMemory = failedCumulativeUserMemory;
        this.userMemoryReservation = userMemoryReservation;
        this.totalMemoryReservation = totalMemoryReservation;
        this.peakUserMemoryReservation = peakUserMemoryReservation;
        this.peakTotalMemoryReservation = peakTotalMemoryReservation;
        this.planningTime = planningTime;
        this.analysisTime = analysisTime;
        this.totalCpuTime = totalCpuTime;
        this.failedCpuTime = failedCpuTime;
        this.totalScheduledTime = totalScheduledTime;
        this.failedScheduledTime = failedScheduledTime;
        this.finishingTime = finishingTime;
        this.physicalInputReadTime = physicalInputReadTime;
        this.fullyBlocked = fullyBlocked;
        this.blockedReasons = ImmutableSet.copyOf((Collection)Objects.requireNonNull(blockedReasons, "blockedReasons is null"));
        this.progressPercentage = Objects.requireNonNull(progressPercentage, "progressPercentage is null");
        this.runningPercentage = Objects.requireNonNull(runningPercentage, "runningPercentage is null");
    }

    public BasicQueryStats(QueryStats queryStats) {
        this(queryStats.getCreateTime(), queryStats.getEndTime(), queryStats.getQueuedTime(), queryStats.getElapsedTime(), queryStats.getExecutionTime(), queryStats.getFailedTasks(), queryStats.getTotalDrivers(), queryStats.getQueuedDrivers(), queryStats.getRunningDrivers(), queryStats.getCompletedDrivers(), queryStats.getBlockedDrivers(), queryStats.getRawInputDataSize(), queryStats.getRawInputPositions(), queryStats.getSpilledDataSize(), queryStats.getPhysicalInputDataSize(), queryStats.getPhysicalWrittenDataSize(), queryStats.getInternalNetworkInputDataSize(), queryStats.getCumulativeUserMemory(), queryStats.getFailedCumulativeUserMemory(), queryStats.getUserMemoryReservation(), queryStats.getTotalMemoryReservation(), queryStats.getPeakUserMemoryReservation(), queryStats.getPeakTotalMemoryReservation(), queryStats.getPlanningTime(), queryStats.getAnalysisTime(), queryStats.getTotalCpuTime(), queryStats.getFailedCpuTime(), queryStats.getTotalScheduledTime(), queryStats.getFailedScheduledTime(), queryStats.getFinishingTime(), queryStats.getPhysicalInputReadTime(), queryStats.isFullyBlocked(), queryStats.getBlockedReasons(), queryStats.getProgressPercentage(), queryStats.getRunningPercentage());
    }

    public static BasicQueryStats immediateFailureQueryStats() {
        DateTime now = DateTime.now();
        return new BasicQueryStats(now, now, new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), 0, 0, 0, 0, 0, 0, DataSize.ofBytes((long)0L), 0L, DataSize.ofBytes((long)0L), DataSize.ofBytes((long)0L), DataSize.ofBytes((long)0L), DataSize.ofBytes((long)0L), 0.0, 0.0, DataSize.ofBytes((long)0L), DataSize.ofBytes((long)0L), DataSize.ofBytes((long)0L), DataSize.ofBytes((long)0L), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), false, (Set<BlockedReason>)ImmutableSet.of(), OptionalDouble.empty(), OptionalDouble.empty());
    }

    @JsonProperty
    public DateTime getCreateTime() {
        return this.createTime;
    }

    @JsonProperty
    public DateTime getEndTime() {
        return this.endTime;
    }

    @JsonProperty
    public Duration getQueuedTime() {
        return this.queuedTime;
    }

    @JsonProperty
    public Duration getElapsedTime() {
        return this.elapsedTime;
    }

    @JsonProperty
    public Duration getExecutionTime() {
        return this.executionTime;
    }

    @JsonProperty
    public int getFailedTasks() {
        return this.failedTasks;
    }

    @JsonProperty
    public int getTotalDrivers() {
        return this.totalDrivers;
    }

    @JsonProperty
    public int getQueuedDrivers() {
        return this.queuedDrivers;
    }

    @JsonProperty
    public int getRunningDrivers() {
        return this.runningDrivers;
    }

    @JsonProperty
    public int getCompletedDrivers() {
        return this.completedDrivers;
    }

    @JsonProperty
    public int getBlockedDrivers() {
        return this.blockedDrivers;
    }

    @JsonProperty
    public DataSize getRawInputDataSize() {
        return this.rawInputDataSize;
    }

    @JsonProperty
    public long getRawInputPositions() {
        return this.rawInputPositions;
    }

    @JsonProperty
    public DataSize getSpilledDataSize() {
        return this.spilledDataSize;
    }

    @JsonProperty
    public DataSize getPhysicalInputDataSize() {
        return this.physicalInputDataSize;
    }

    @JsonProperty
    public DataSize getPhysicalWrittenDataSize() {
        return this.physicalWrittenDataSize;
    }

    @JsonProperty
    public DataSize getInternalNetworkInputDataSize() {
        return this.internalNetworkInputDataSize;
    }

    @JsonProperty
    public double getCumulativeUserMemory() {
        return this.cumulativeUserMemory;
    }

    @JsonProperty
    public double getFailedCumulativeUserMemory() {
        return this.failedCumulativeUserMemory;
    }

    @JsonProperty
    public DataSize getUserMemoryReservation() {
        return this.userMemoryReservation;
    }

    @JsonProperty
    public DataSize getTotalMemoryReservation() {
        return this.totalMemoryReservation;
    }

    @JsonProperty
    public DataSize getPeakUserMemoryReservation() {
        return this.peakUserMemoryReservation;
    }

    @JsonProperty
    public DataSize getPeakTotalMemoryReservation() {
        return this.peakTotalMemoryReservation;
    }

    @JsonProperty
    public Duration getPlanningTime() {
        return this.planningTime;
    }

    @JsonProperty
    public Duration getAnalysisTime() {
        return this.analysisTime;
    }

    @JsonProperty
    public Duration getTotalCpuTime() {
        return this.totalCpuTime;
    }

    @JsonProperty
    public Duration getFailedCpuTime() {
        return this.failedCpuTime;
    }

    @JsonProperty
    public Duration getTotalScheduledTime() {
        return this.totalScheduledTime;
    }

    @JsonProperty
    public Duration getFailedScheduledTime() {
        return this.failedScheduledTime;
    }

    @JsonProperty
    public Duration getFinishingTime() {
        return this.finishingTime;
    }

    @JsonProperty
    public Duration getPhysicalInputReadTime() {
        return this.physicalInputReadTime;
    }

    @JsonProperty
    public boolean isFullyBlocked() {
        return this.fullyBlocked;
    }

    @JsonProperty
    public Set<BlockedReason> getBlockedReasons() {
        return this.blockedReasons;
    }

    @JsonProperty
    public OptionalDouble getProgressPercentage() {
        return this.progressPercentage;
    }

    @JsonProperty
    public OptionalDouble getRunningPercentage() {
        return this.runningPercentage;
    }
}

