/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import io.airlift.log.Logger;
import jakarta.annotation.Priority;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.ext.Provider;
import jakarta.ws.rs.ext.WriterInterceptor;
import jakarta.ws.rs.ext.WriterInterceptorContext;
import java.io.IOException;

@Provider
@Priority(value=11)
public class IoExceptionSuppressingWriterInterceptor
implements WriterInterceptor {
    private static final Logger log = Logger.get(IoExceptionSuppressingWriterInterceptor.class);

    public void aroundWriteTo(WriterInterceptorContext context) throws WebApplicationException {
        try {
            context.proceed();
        }
        catch (IOException e) {
            log.warn("Could not write to output: %s(%s)", new Object[]{e.getClass().getSimpleName(), e.getMessage()});
        }
    }
}

