/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import io.trino.execution.BasicStageInfo;
import io.trino.execution.ExecutionFailureInfo;
import io.trino.execution.QueryInfo;
import io.trino.execution.QueryState;
import io.trino.server.BasicQueryStats;
import io.trino.spi.ErrorCode;
import io.trino.spi.QueryId;
import io.trino.spi.TrinoWarning;
import io.trino.spi.security.SelectedRole;
import io.trino.transaction.TransactionId;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public record ResultQueryInfo(@JsonProperty QueryId queryId, @JsonProperty QueryState state, @JsonProperty boolean scheduled, @JsonProperty String updateType, @JsonProperty BasicQueryStats queryStats, @JsonProperty ErrorCode errorCode, @JsonProperty Optional<BasicStageInfo> outputStage, @JsonProperty boolean finalQueryInfo, @JsonProperty ExecutionFailureInfo failureInfo, @JsonProperty Optional<String> setCatalog, @JsonProperty Optional<String> setSchema, @JsonProperty Optional<String> setPath, @JsonProperty Optional<String> setAuthorizationUser, @JsonProperty boolean resetAuthorizationUser, @JsonProperty Set<SelectedRole> setOriginalRoles, @JsonProperty Map<String, String> setSessionProperties, @JsonProperty Set<String> resetSessionProperties, @JsonProperty Map<String, SelectedRole> setRoles, @JsonProperty Map<String, String> addedPreparedStatements, @JsonProperty Set<String> deallocatedPreparedStatements, @JsonProperty Optional<TransactionId> startedTransactionId, @JsonProperty boolean clearTransactionId, @JsonProperty List<TrinoWarning> warnings) {
    @JsonCreator
    public ResultQueryInfo(@JsonProperty(value="queryId") QueryId queryId, @JsonProperty(value="state") QueryState state, @JsonProperty(value="scheduled") boolean scheduled, @JsonProperty(value="updateType") String updateType, @JsonProperty(value="queryStats") BasicQueryStats queryStats, @JsonProperty(value="errorCode") ErrorCode errorCode, @JsonProperty(value="outputStage") Optional<BasicStageInfo> outputStage, @JsonProperty(value="finalQueryInfo") boolean finalQueryInfo, @JsonProperty(value="failureInfo") ExecutionFailureInfo failureInfo, @JsonProperty(value="setCatalog") Optional<String> setCatalog, @JsonProperty(value="setSchema") Optional<String> setSchema, @JsonProperty(value="setPath") Optional<String> setPath, @JsonProperty(value="setAuthorizationUser") Optional<String> setAuthorizationUser, @JsonProperty(value="resetAuthorizationUser") boolean resetAuthorizationUser, @JsonProperty(value="setOriginalRoles") Set<SelectedRole> setOriginalRoles, @JsonProperty(value="setSessionProperties") Map<String, String> setSessionProperties, @JsonProperty(value="resetSessionProperties") Set<String> resetSessionProperties, @JsonProperty(value="setRoles") Map<String, SelectedRole> setRoles, @JsonProperty(value="addedPreparedStatements") Map<String, String> addedPreparedStatements, @JsonProperty(value="deallocatedPreparedStatements") Set<String> deallocatedPreparedStatements, @JsonProperty(value="startedTransactionId") Optional<TransactionId> startedTransactionId, @JsonProperty(value="clearTransactionId") boolean clearTransactionId, @JsonProperty(value="warnings") List<TrinoWarning> warnings) {
        this.queryId = Objects.requireNonNull(queryId, "queryId is null");
        this.state = Objects.requireNonNull(state, "state is null");
        this.scheduled = scheduled;
        this.errorCode = errorCode;
        this.updateType = updateType;
        this.queryStats = Objects.requireNonNull(queryStats, "queryStats is null");
        this.outputStage = Objects.requireNonNull(outputStage, "outputStage is null");
        this.finalQueryInfo = finalQueryInfo;
        this.failureInfo = failureInfo;
        this.setCatalog = Objects.requireNonNull(setCatalog, "setCatalog is null");
        this.setSchema = Objects.requireNonNull(setSchema, "setSchema is null");
        this.setPath = Objects.requireNonNull(setPath, "setPath is null");
        this.setAuthorizationUser = Objects.requireNonNull(setAuthorizationUser, "setAuthorizationUser is null");
        this.resetAuthorizationUser = resetAuthorizationUser;
        this.setOriginalRoles = Objects.requireNonNull(setOriginalRoles, "setOriginalRoles is null");
        this.setSessionProperties = Objects.requireNonNull(setSessionProperties, "setSessionProperties is null");
        this.resetSessionProperties = Objects.requireNonNull(resetSessionProperties, "resetSessionProperties is null");
        this.addedPreparedStatements = Objects.requireNonNull(addedPreparedStatements, "addedPreparedStatements is null");
        this.deallocatedPreparedStatements = Objects.requireNonNull(deallocatedPreparedStatements, "deallocatedPreparedStatements is null");
        this.startedTransactionId = Objects.requireNonNull(startedTransactionId, "startedTransactionId is null");
        this.setRoles = Objects.requireNonNull(setRoles, "setRoles is null");
        this.clearTransactionId = clearTransactionId;
        this.warnings = Objects.requireNonNull(warnings, "warnings is null");
    }

    public ResultQueryInfo(QueryInfo queryInfo) {
        this(queryInfo.getQueryId(), queryInfo.getState(), queryInfo.isScheduled(), queryInfo.getUpdateType(), new BasicQueryStats(queryInfo.getQueryStats()), queryInfo.getErrorCode(), queryInfo.getOutputStage().map(BasicStageInfo::new), queryInfo.isFinalQueryInfo(), queryInfo.getFailureInfo(), queryInfo.getSetCatalog(), queryInfo.getSetSchema(), queryInfo.getSetPath(), queryInfo.getSetAuthorizationUser(), queryInfo.isResetAuthorizationUser(), queryInfo.getSetOriginalRoles(), queryInfo.getSetSessionProperties(), queryInfo.getResetSessionProperties(), queryInfo.getSetRoles(), queryInfo.getAddedPreparedStatements(), queryInfo.getDeallocatedPreparedStatements(), queryInfo.getStartedTransactionId(), queryInfo.isClearTransactionId(), queryInfo.getWarnings());
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("queryId", (Object)this.queryId).add("state", (Object)this.state).toString();
    }
}

