/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.opentelemetry.api.trace.Span;
import io.trino.SessionRepresentation;
import io.trino.execution.SplitAssignment;
import io.trino.execution.buffer.OutputBuffers;
import io.trino.spi.predicate.Domain;
import io.trino.sql.planner.PlanFragment;
import io.trino.sql.planner.plan.DynamicFilterId;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public record TaskUpdateRequest(SessionRepresentation session, Map<String, String> extraCredentials, Span stageSpan, Optional<PlanFragment> fragment, List<SplitAssignment> splitAssignments, OutputBuffers outputIds, Map<DynamicFilterId, Domain> dynamicFilterDomains, Optional<Slice> exchangeEncryptionKey, boolean speculative) {
    public TaskUpdateRequest {
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(extraCredentials, "extraCredentials is null");
        Objects.requireNonNull(stageSpan, "stageSpan is null");
        Objects.requireNonNull(fragment, "fragment is null");
        splitAssignments = ImmutableList.copyOf(splitAssignments);
        Objects.requireNonNull(outputIds, "outputIds is null");
        dynamicFilterDomains = ImmutableMap.copyOf(dynamicFilterDomains);
        Objects.requireNonNull(exchangeEncryptionKey, "exchangeEncryptionKey is null");
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("session", (Object)this.session).add("extraCredentials", this.extraCredentials.keySet()).add("fragment", this.fragment).add("splitAssignments", this.splitAssignments).add("outputIds", (Object)this.outputIds).add("dynamicFilterDomains", this.dynamicFilterDomains).add("exchangeEncryptionKey", this.exchangeEncryptionKey.map(slice -> "[REDACTED]")).add("speculative", this.speculative).toString();
    }
}

