/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.protocol;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.trino.client.Column;
import io.trino.server.protocol.OutputColumn;
import io.trino.server.protocol.ProtocolUtil;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;

public class QueryResultRows {
    private final Optional<List<OutputColumn>> columns;
    private final List<Page> pages;
    private final long totalRows;

    private QueryResultRows(Optional<List<OutputColumn>> columns, List<Page> pages) {
        this.columns = Objects.requireNonNull(columns, "columns is null").map(values -> (List)values.stream().collect(ImmutableList.toImmutableList()));
        this.pages = ImmutableList.copyOf(pages);
        this.totalRows = QueryResultRows.countRows(pages);
        Verify.verify((this.totalRows == 0L || this.totalRows > 0L && columns.isPresent() ? 1 : 0) != 0, (String)"data present without columns and types", (Object[])new Object[0]);
    }

    public boolean isEmpty() {
        return this.totalRows == 0L;
    }

    public List<OutputColumn> getOutputColumns() {
        return this.columns.orElseThrow(() -> new IllegalStateException("Columns are not present"));
    }

    public List<Column> getOptionalColumns() {
        return this.columns.map(columns -> (ImmutableList)columns.stream().map(value -> ProtocolUtil.createColumn(value.columnName(), value.type(), true)).collect(ImmutableList.toImmutableList())).orElse(null);
    }

    public List<Page> getPages() {
        return this.pages;
    }

    public OptionalLong getUpdateCount() {
        if (this.totalRows != 1L || this.columns.isEmpty()) {
            return OptionalLong.empty();
        }
        List<OutputColumn> onlyColumn = this.columns.get();
        if (onlyColumn.size() != 1 || !onlyColumn.getFirst().type().equals((Object)BigintType.BIGINT)) {
            return OptionalLong.empty();
        }
        Preconditions.checkState((!this.pages.isEmpty() ? 1 : 0) != 0, (Object)"no data pages available");
        Block block = this.pages.getFirst().getBlock(0);
        if (block.isNull(0)) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(BigintType.BIGINT.getLong(block, 0));
    }

    private static long countRows(List<Page> pages) {
        long rows = 0L;
        for (Page page : pages) {
            rows += (long)page.getPositionCount();
        }
        return rows;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("columns", this.columns).add("totalRowsCount", this.totalRows).add("pagesCount", this.pages.size()).toString();
    }

    public static QueryResultRows empty() {
        return new QueryResultRows(Optional.empty(), (List<Page>)ImmutableList.of());
    }

    public static Builder queryResultRowsBuilder() {
        return new Builder();
    }

    public static class Builder {
        private ImmutableList.Builder<Page> pages = ImmutableList.builder();
        private Optional<List<OutputColumn>> columns = Optional.empty();

        public Builder addPage(Page page) {
            this.pages.add((Object)page);
            return this;
        }

        public Builder addPages(List<Page> page) {
            this.pages.addAll(page);
            return this;
        }

        public Builder withColumnsAndTypes(List<Column> columns, List<Type> types) {
            this.columns = Builder.combine(columns, types);
            return this;
        }

        public QueryResultRows build() {
            return new QueryResultRows(this.columns, (List<Page>)this.pages.build());
        }

        private static Optional<List<OutputColumn>> combine(List<Column> columns, List<Type> types) {
            if (columns == null && types == null) {
                return Optional.empty();
            }
            Preconditions.checkArgument((columns != null && types != null ? 1 : 0) != 0, (Object)"columns and types must be present at the same time");
            Preconditions.checkArgument((columns.size() == types.size() ? 1 : 0) != 0, (Object)"columns and types size mismatch");
            ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)columns.size());
            for (int i = 0; i < columns.size(); ++i) {
                builder.add((Object)new OutputColumn(i, columns.get(i).getName(), types.get(i)));
            }
            return Optional.of(builder.build());
        }
    }
}

