/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.protocol.spooling;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanSerializerFactory;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.trino.client.JsonQueryData;
import io.trino.client.QueryData;
import io.trino.client.TypedQueryData;
import io.trino.client.spooling.EncodedQueryData;
import io.trino.client.spooling.InlineSegment;
import io.trino.client.spooling.Segment;
import io.trino.client.spooling.SpooledSegment;
import io.trino.server.protocol.JsonBytesQueryData;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;

public class QueryDataJacksonModule
extends SimpleModule {
    public QueryDataJacksonModule() {
        super(QueryDataJacksonModule.class.getSimpleName(), Version.unknownVersion());
        this.addSerializer(QueryData.class, (JsonSerializer)new Serializer());
        this.addSerializer(Segment.class, (JsonSerializer)new SegmentSerializer());
        this.registerSubtypes(new Class[]{InlineSegment.class});
        this.registerSubtypes(new Class[]{SpooledSegment.class});
    }

    private static <T> JsonSerializer<T> createSerializer(SerializerProvider provider, JavaType javaType) throws JsonMappingException {
        return BeanSerializerFactory.instance.createSerializer(provider, javaType);
    }

    private static class Serializer
    extends StdSerializer<QueryData> {
        public Serializer() {
            super(QueryData.class);
        }

        public void serialize(QueryData value, JsonGenerator generator, SerializerProvider provider) throws IOException {
            QueryData queryData = value;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JsonQueryData.class, JsonBytesQueryData.class, TypedQueryData.class, EncodedQueryData.class}, (QueryData)queryData, n)) {
                case -1: {
                    provider.defaultSerializeNull(generator);
                    break;
                }
                case 0: {
                    JsonQueryData jsonQueryData = (JsonQueryData)queryData;
                    generator.writeTree((TreeNode)jsonQueryData.getNode());
                    break;
                }
                case 1: {
                    JsonBytesQueryData jsonBytes = (JsonBytesQueryData)queryData;
                    jsonBytes.writeTo(generator);
                    break;
                }
                case 2: {
                    TypedQueryData typedQueryData = (TypedQueryData)queryData;
                    provider.defaultSerializeValue((Object)typedQueryData.getIterable(), generator);
                    break;
                }
                case 3: {
                    EncodedQueryData encoded = (EncodedQueryData)queryData;
                    QueryDataJacksonModule.createSerializer(provider, provider.constructType(EncodedQueryData.class)).serialize((Object)encoded, generator, provider);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported QueryData implementation: " + value.getClass().getSimpleName());
                }
            }
        }

        public boolean isEmpty(SerializerProvider provider, QueryData value) {
            return value == null || value.isNull();
        }
    }

    private static class SegmentSerializer
    extends StdSerializer<Segment> {
        protected SegmentSerializer() {
            super(Segment.class);
        }

        public void serialize(Segment value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            QueryDataJacksonModule.createSerializer(provider, provider.constructSpecializedType(provider.constructType(Segment.class), value.getClass())).serializeWithType((Object)value, gen, provider, SegmentSerializer.segmentSerializer(provider));
        }

        private static TypeSerializer segmentSerializer(SerializerProvider provider) {
            try {
                return provider.findTypeSerializer(provider.constructType(Segment.class));
            }
            catch (JsonMappingException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

