/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.protocol.spooling;

import com.google.common.base.Verify;
import io.airlift.json.JsonCodec;
import io.airlift.slice.Slices;
import io.trino.client.spooling.DataAttributes;
import io.trino.server.protocol.spooling.SpooledMetadataBlock;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.RowBlockBuilder;
import io.trino.spi.block.SqlRow;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.io.InputStream;
import java.lang.runtime.SwitchBootstraps;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class SpooledMetadataBlockSerde {
    private static final JsonCodec<Map<String, List<String>>> HEADERS_CODEC = JsonCodec.mapJsonCodec(String.class, (JsonCodec)JsonCodec.listJsonCodec(String.class));
    private static final JsonCodec<DataAttributes> ATTRIBUTES_CODEC = JsonCodec.jsonCodec(DataAttributes.class);
    private static final RowType SPOOLING_METADATA_TYPE = RowType.from(List.of(new RowType.Field(Optional.empty(), (Type)VarcharType.VARCHAR), new RowType.Field(Optional.empty(), (Type)VarbinaryType.VARBINARY), new RowType.Field(Optional.empty(), (Type)VarcharType.VARCHAR), new RowType.Field(Optional.empty(), (Type)VarcharType.VARCHAR), new RowType.Field(Optional.empty(), (Type)VarcharType.VARCHAR)));

    private SpooledMetadataBlockSerde() {
    }

    public static Page serialize(SpooledMetadataBlock block) {
        RowBlockBuilder rowBlockBuilder = SPOOLING_METADATA_TYPE.createBlockBuilder(null, 1);
        rowBlockBuilder.buildEntry(rowEntryBuilder -> {
            VarcharType.VARCHAR.writeSlice((BlockBuilder)rowEntryBuilder.get(0), Slices.utf8Slice((String)ATTRIBUTES_CODEC.toJson((Object)block.attributes())));
            SpooledMetadataBlock spooledMetadataBlock = block;
            Objects.requireNonNull(spooledMetadataBlock);
            SpooledMetadataBlock selector0$temp = spooledMetadataBlock;
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SpooledMetadataBlock.Inlined.class, SpooledMetadataBlock.Spooled.class}, (SpooledMetadataBlock)selector0$temp, index$1)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    SpooledMetadataBlock.Inlined inlined = (SpooledMetadataBlock.Inlined)selector0$temp;
                    VarbinaryType.VARBINARY.writeSlice((BlockBuilder)rowEntryBuilder.get(1), inlined.data());
                    ((BlockBuilder)rowEntryBuilder.get(2)).appendNull();
                    ((BlockBuilder)rowEntryBuilder.get(3)).appendNull();
                    ((BlockBuilder)rowEntryBuilder.get(4)).appendNull();
                    break;
                }
                case 1: {
                    SpooledMetadataBlock.Spooled spooled = (SpooledMetadataBlock.Spooled)selector0$temp;
                    ((BlockBuilder)rowEntryBuilder.get(1)).appendNull();
                    VarcharType.VARCHAR.writeSlice((BlockBuilder)rowEntryBuilder.get(2), Slices.utf8Slice((String)spooled.identifier().toStringUtf8()));
                    if (spooled.directUri().isPresent()) {
                        VarcharType.VARCHAR.writeSlice((BlockBuilder)rowEntryBuilder.get(3), Slices.utf8Slice((String)spooled.directUri().orElseThrow().toString()));
                    } else {
                        ((BlockBuilder)rowEntryBuilder.get(3)).appendNull();
                    }
                    VarcharType.VARCHAR.writeSlice((BlockBuilder)rowEntryBuilder.get(4), Slices.utf8Slice((String)HEADERS_CODEC.toJson(spooled.headers())));
                }
            }
        });
        return new Page(new Block[]{rowBlockBuilder.build()});
    }

    public static SpooledMetadataBlock deserialize(Page page) {
        Verify.verify((page.getPositionCount() == 1 ? 1 : 0) != 0, (String)"Spooling metadata block must have a single position", (Object[])new Object[0]);
        Verify.verify((page.getChannelCount() == 1 ? 1 : 0) != 0, (String)"Spooling metadata block must have a single channel", (Object[])new Object[0]);
        SqlRow row = SPOOLING_METADATA_TYPE.getObject(page.getBlock(0), 0);
        DataAttributes dataAttributes = (DataAttributes)ATTRIBUTES_CODEC.fromJson((InputStream)VarcharType.VARCHAR.getSlice(row.getRawFieldBlock(0), 0).getInput());
        if (row.getRawFieldBlock(1).isNull(0)) {
            return new SpooledMetadataBlock.Spooled(dataAttributes, VarcharType.VARCHAR.getSlice(row.getRawFieldBlock(2), 0), SpooledMetadataBlockSerde.extractDirectUri(row), (Map)HEADERS_CODEC.fromJson((InputStream)VarcharType.VARCHAR.getSlice(row.getRawFieldBlock(4), 0).getInput()));
        }
        return new SpooledMetadataBlock.Inlined(dataAttributes, VarbinaryType.VARBINARY.getSlice(row.getRawFieldBlock(1), 0));
    }

    private static Optional<URI> extractDirectUri(SqlRow row) {
        if (row.getRawFieldBlock(3).isNull(0)) {
            return Optional.empty();
        }
        return Optional.of(URI.create(VarcharType.VARCHAR.getSlice(row.getRawFieldBlock(3), 0).toStringUtf8()));
    }
}

