/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.protocol.spooling;

import io.airlift.slice.Slice;
import io.trino.Session;
import io.trino.client.QueryData;
import io.trino.client.spooling.DataAttribute;
import io.trino.client.spooling.DataAttributes;
import io.trino.client.spooling.EncodedQueryData;
import io.trino.client.spooling.Segment;
import io.trino.server.ExternalUriInfo;
import io.trino.server.protocol.QueryDataProducer;
import io.trino.server.protocol.QueryResultRows;
import io.trino.server.protocol.spooling.CoordinatorSegmentResource;
import io.trino.server.protocol.spooling.SpooledMetadataBlock;
import io.trino.server.protocol.spooling.SpooledMetadataBlockSerde;
import io.trino.spi.Page;
import io.trino.spi.TrinoException;
import jakarta.ws.rs.core.UriBuilder;
import java.lang.runtime.SwitchBootstraps;
import java.net.URI;
import java.util.Objects;
import java.util.function.Consumer;

public class SpoolingQueryDataProducer
implements QueryDataProducer {
    private long currentOffset;

    @Override
    public QueryData produce(ExternalUriInfo uriInfo, Session session, QueryResultRows rows, Consumer<TrinoException> throwableConsumer) {
        if (rows.isEmpty()) {
            return null;
        }
        EncodedQueryData.Builder builder = EncodedQueryData.builder((String)session.getQueryDataEncoding().orElseThrow());
        UriBuilder uriBuilder = CoordinatorSegmentResource.spooledSegmentUriBuilder(uriInfo);
        for (Page page : rows.getPages()) {
            SpooledMetadataBlock spooledMetadataBlock;
            SpooledMetadataBlock metadataBlock = SpooledMetadataBlockSerde.deserialize(page);
            DataAttributes attributes = metadataBlock.attributes().toBuilder().set(DataAttribute.ROW_OFFSET, (Object)this.currentOffset).build();
            Objects.requireNonNull(metadataBlock);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SpooledMetadataBlock.Spooled.class, SpooledMetadataBlock.Inlined.class}, (SpooledMetadataBlock)spooledMetadataBlock, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    SpooledMetadataBlock.Spooled spooled = (SpooledMetadataBlock.Spooled)spooledMetadataBlock;
                    builder.withSegment(Segment.spooled((URI)spooled.directUri().orElseGet(() -> this.buildSegmentDownloadURI(uriBuilder, spooled.identifier())), (URI)this.buildSegmentAckURI(uriBuilder, spooled.identifier()), (DataAttributes)attributes, spooled.headers()));
                    break;
                }
                case 1: {
                    SpooledMetadataBlock.Inlined inlined = (SpooledMetadataBlock.Inlined)spooledMetadataBlock;
                    builder.withSegment(Segment.inlined((byte[])inlined.data().byteArray(), (DataAttributes)attributes));
                }
            }
            this.currentOffset += ((Long)attributes.get(DataAttribute.ROWS_COUNT, Long.class)).longValue();
        }
        return builder.build();
    }

    @Override
    public void close() {
    }

    private URI buildSegmentDownloadURI(UriBuilder builder, Slice identifier) {
        return builder.clone().path("download/{identifier}").build(new Object[]{identifier.toStringUtf8()});
    }

    private URI buildSegmentAckURI(UriBuilder builder, Slice identifier) {
        return builder.clone().path("ack/{identifier}").build(new Object[]{identifier.toStringUtf8()});
    }
}

