/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.protocol.spooling.encoding;

import com.google.common.primitives.Ints;
import io.trino.client.spooling.DataAttribute;
import io.trino.client.spooling.DataAttributes;
import io.trino.server.protocol.spooling.QueryDataEncoder;
import io.trino.spi.Page;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public abstract class CompressedQueryDataEncoder
implements QueryDataEncoder {
    protected final QueryDataEncoder delegate;
    private final int compressionThreshold;

    protected CompressedQueryDataEncoder(QueryDataEncoder delegate, int compressionThreshold) {
        this.delegate = delegate;
        this.compressionThreshold = compressionThreshold;
    }

    @Override
    public DataAttributes encodeTo(OutputStream output, List<Page> pages) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(CompressedQueryDataEncoder.pagesSize(pages));
        DataAttributes attributes = this.delegate.encodeTo(buffer, pages);
        int uncompressedSize = (Integer)attributes.get(DataAttribute.SEGMENT_SIZE, Integer.class);
        if (uncompressedSize < this.compressionThreshold) {
            buffer.writeTo(output);
            return attributes;
        }
        return attributes.toBuilder().set(DataAttribute.SEGMENT_SIZE, (Object)this.compress(buffer.toByteArray(), uncompressedSize, output)).set(DataAttribute.UNCOMPRESSED_SIZE, (Object)uncompressedSize).build();
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    protected abstract int compress(byte[] var1, int var2, OutputStream var3) throws IOException;

    protected static int pagesSize(List<Page> pages) {
        return Ints.saturatedCast((long)pages.stream().mapToLong(Page::getSizeInBytes).sum());
    }
}

