/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.ui;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import io.trino.server.security.ResourceSecurity;
import io.trino.server.ui.AuthInfo;
import io.trino.server.ui.FormWebUiAuthenticationFilter;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import java.util.Objects;
import java.util.Optional;

@Path(value="")
@ResourceSecurity(value=ResourceSecurity.AccessType.WEB_UI)
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class LoginPreviewResource {
    private final FormWebUiAuthenticationFilter formWebUiAuthenticationManager;

    @Inject
    public LoginPreviewResource(FormWebUiAuthenticationFilter formWebUiAuthenticationManager) {
        this.formWebUiAuthenticationManager = Objects.requireNonNull(formWebUiAuthenticationManager, "formWebUiAuthenticationManager is null");
    }

    @GET
    @Path(value="/ui/preview/auth/info")
    public AuthInfo getAuthInfo(ContainerRequestContext request, @Context SecurityContext securityContext) {
        boolean isPasswordAllowed = this.formWebUiAuthenticationManager.isPasswordAllowed(securityContext.isSecure());
        Optional<String> username = this.formWebUiAuthenticationManager.getAuthenticatedUsername(request);
        return new AuthInfo("form", isPasswordAllowed, username.isPresent(), username);
    }

    @POST
    @Path(value="/ui/preview/auth/login")
    public Response login(LoginForm loginForm, @Context SecurityContext securityContext) {
        String username = Strings.emptyToNull((String)loginForm.username());
        String password = Strings.emptyToNull((String)loginForm.password());
        if (!this.formWebUiAuthenticationManager.isAuthenticationEnabled(securityContext.isSecure())) {
            throw new ForbiddenException();
        }
        Optional<NewCookie[]> authenticationCookie = this.formWebUiAuthenticationManager.checkLoginCredentials(username, password, securityContext.isSecure());
        if (authenticationCookie.isEmpty()) {
            throw new ForbiddenException();
        }
        return Response.noContent().cookie(authenticationCookie.get()).build();
    }

    @GET
    @Path(value="/ui/preview/auth/logout")
    public Response logout(@Context HttpHeaders httpHeaders, @Context SecurityContext securityContext) {
        return Response.noContent().cookie(FormWebUiAuthenticationFilter.getDeleteCookies(httpHeaders.getCookies(), securityContext.isSecure())).build();
    }

    public record LoginForm(@JsonProperty String username, @JsonProperty String password) {
    }
}

