/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.ui;

import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.google.common.io.Resources;
import com.google.inject.Inject;
import io.trino.server.ExternalUriInfo;
import io.trino.server.security.ResourceSecurity;
import io.trino.server.ui.FormWebUiAuthenticationFilter;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;

@Path(value="")
@ResourceSecurity(value=ResourceSecurity.AccessType.WEB_UI)
public class LoginResource {
    private static final String REPLACEMENT_TEXT = "<div class=\"hidden\" id=\"hide-password\">false</div> <!-- This value will be replaced -->";
    private final FormWebUiAuthenticationFilter formWebUiAuthenticationManager;
    private final String loginHtml;

    @Inject
    public LoginResource(FormWebUiAuthenticationFilter formWebUiAuthenticationManager) throws IOException {
        this.formWebUiAuthenticationManager = Objects.requireNonNull(formWebUiAuthenticationManager, "formWebUiAuthenticationManager is null");
        this.loginHtml = Resources.toString((URL)Resources.getResource(this.getClass(), (String)"/webapp/login.html"), (Charset)StandardCharsets.UTF_8);
        Verify.verify((boolean)this.loginHtml.contains(REPLACEMENT_TEXT), (String)"login.html does not contain the replacement text", (Object[])new Object[0]);
    }

    @GET
    @Path(value="/ui/login.html")
    public Response getFile(@Context SecurityContext securityContext) {
        boolean passwordAllowed = this.formWebUiAuthenticationManager.isPasswordAllowed(securityContext.isSecure());
        return Response.ok((Object)this.loginHtml.replace(REPLACEMENT_TEXT, "<div class=\"hidden\" id=\"hide-password\">" + !passwordAllowed + "</div>")).type("text/html").build();
    }

    @POST
    @Path(value="/ui/login")
    public Response login(@FormParam(value="username") String username, @FormParam(value="password") String password, @FormParam(value="redirectPath") String redirectPath, @Context SecurityContext securityContext, @BeanParam ExternalUriInfo externalUriInfo) {
        username = Strings.emptyToNull((String)username);
        password = Strings.emptyToNull((String)password);
        redirectPath = Strings.emptyToNull((String)redirectPath);
        if (!this.formWebUiAuthenticationManager.isAuthenticationEnabled(securityContext.isSecure())) {
            return Response.seeOther((URI)externalUriInfo.absolutePath("/ui/disabled.html")).build();
        }
        Optional<NewCookie[]> authenticationCookie = this.formWebUiAuthenticationManager.checkLoginCredentials(username, password, securityContext.isSecure());
        if (authenticationCookie.isEmpty()) {
            return Response.seeOther((URI)externalUriInfo.absolutePath("/ui/login.html")).build();
        }
        return FormWebUiAuthenticationFilter.redirectFromSuccessfulLoginResponse(externalUriInfo, redirectPath).cookie(authenticationCookie.get()).build();
    }

    @GET
    @Path(value="/ui/logout")
    public Response logout(@Context HttpHeaders httpHeaders, @Context SecurityContext securityContext, @BeanParam ExternalUriInfo externalUriInfo) {
        URI redirectLocation = this.formWebUiAuthenticationManager.isAuthenticationEnabled(securityContext.isSecure()) ? externalUriInfo.absolutePath("/ui/login.html") : externalUriInfo.absolutePath("/ui/disabled.html");
        return Response.seeOther((URI)redirectLocation).cookie(FormWebUiAuthenticationFilter.getDeleteCookies(httpHeaders.getCookies(), securityContext.isSecure())).build();
    }
}

