/*
 * Decompiled with CFR 0.152.
 */
package io.trino.split;

import com.google.inject.Inject;
import io.trino.Session;
import io.trino.connector.CatalogServiceProvider;
import io.trino.metadata.InsertTableHandle;
import io.trino.metadata.MergeHandle;
import io.trino.metadata.OutputTableHandle;
import io.trino.metadata.TableExecuteHandle;
import io.trino.metadata.TableHandle;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.ConnectorMergeSink;
import io.trino.spi.connector.ConnectorPageSink;
import io.trino.spi.connector.ConnectorPageSinkId;
import io.trino.spi.connector.ConnectorPageSinkProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.split.PageSinkProvider;
import java.util.Objects;

public class PageSinkManager
implements PageSinkProvider {
    private final CatalogServiceProvider<ConnectorPageSinkProvider> pageSinkProvider;

    @Inject
    public PageSinkManager(CatalogServiceProvider<ConnectorPageSinkProvider> pageSinkProvider) {
        this.pageSinkProvider = Objects.requireNonNull(pageSinkProvider, "pageSinkProvider is null");
    }

    @Override
    public ConnectorPageSink createPageSink(Session session, OutputTableHandle tableHandle, ConnectorPageSinkId pageSinkId) {
        ConnectorSession connectorSession = session.toConnectorSession(tableHandle.catalogHandle());
        return this.providerFor(tableHandle.catalogHandle()).createPageSink(tableHandle.transactionHandle(), connectorSession, tableHandle.connectorHandle(), pageSinkId);
    }

    @Override
    public ConnectorPageSink createPageSink(Session session, InsertTableHandle tableHandle, ConnectorPageSinkId pageSinkId) {
        ConnectorSession connectorSession = session.toConnectorSession(tableHandle.catalogHandle());
        return this.providerFor(tableHandle.catalogHandle()).createPageSink(tableHandle.transactionHandle(), connectorSession, tableHandle.connectorHandle(), pageSinkId);
    }

    @Override
    public ConnectorPageSink createPageSink(Session session, TableExecuteHandle tableHandle, ConnectorPageSinkId pageSinkId) {
        ConnectorSession connectorSession = session.toConnectorSession(tableHandle.catalogHandle());
        return this.providerFor(tableHandle.catalogHandle()).createPageSink(tableHandle.transactionHandle(), connectorSession, tableHandle.connectorHandle(), pageSinkId);
    }

    @Override
    public ConnectorMergeSink createMergeSink(Session session, MergeHandle mergeHandle, ConnectorPageSinkId pageSinkId) {
        TableHandle tableHandle = mergeHandle.tableHandle();
        ConnectorSession connectorSession = session.toConnectorSession(tableHandle.catalogHandle());
        return this.providerFor(tableHandle.catalogHandle()).createMergeSink(tableHandle.transaction(), connectorSession, mergeHandle.connectorMergeHandle(), pageSinkId);
    }

    private ConnectorPageSinkProvider providerFor(CatalogHandle catalogHandle) {
        return this.pageSinkProvider.getService(catalogHandle);
    }
}

