/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.analyzer;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.metadata.ResolvedFunction;
import io.trino.sql.analyzer.Analysis;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.RangeQuantifier;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public record PatternRecognitionAnalysis(Set<String> allLabels, Set<String> undefinedLabels, Map<NodeRef<RangeQuantifier>, Analysis.Range> ranges) {
    public PatternRecognitionAnalysis(Set<String> allLabels, Set<String> undefinedLabels, Map<NodeRef<RangeQuantifier>, Analysis.Range> ranges) {
        this.allLabels = Objects.requireNonNull(allLabels, "allLabels is null");
        this.undefinedLabels = ImmutableSet.copyOf(undefinedLabels);
        this.ranges = ImmutableMap.copyOf(ranges);
    }

    public record Navigation(NavigationAnchor anchor, NavigationMode mode, int logicalOffset, int physicalOffset) {
        public static final Navigation DEFAULT = new Navigation(NavigationAnchor.LAST, NavigationMode.RUNNING, 0, 0);

        public Navigation {
            Objects.requireNonNull(anchor, "anchor is null");
            Objects.requireNonNull(mode, "mode is null");
        }
    }

    public static enum NavigationAnchor {
        FIRST,
        LAST;

    }

    public record MatchNumberDescriptor() implements Descriptor
    {
    }

    public record ClassifierDescriptor(Optional<String> label, Navigation navigation) implements Descriptor
    {
        public ClassifierDescriptor {
            Objects.requireNonNull(label, "label is null");
            Objects.requireNonNull(navigation, "navigation is null");
        }
    }

    public record ScalarInputDescriptor(Optional<String> label, Navigation navigation) implements Descriptor
    {
        public ScalarInputDescriptor {
            Objects.requireNonNull(label, "label is null");
            Objects.requireNonNull(navigation, "navigation is null");
        }
    }

    public record AggregationDescriptor(ResolvedFunction function, List<Expression> arguments, NavigationMode mode, Set<String> labels, List<FunctionCall> matchNumberCalls, List<FunctionCall> classifierCalls) implements Descriptor
    {
        public AggregationDescriptor {
            Objects.requireNonNull(function, "function is null");
            Objects.requireNonNull(arguments, "arguments is null");
            Objects.requireNonNull(mode, "mode is null");
            Objects.requireNonNull(labels, "labels is null");
            Objects.requireNonNull(matchNumberCalls, "matchNumberCalls is null");
            Objects.requireNonNull(classifierCalls, "classifierCalls is null");
        }
    }

    public static sealed interface Descriptor
    permits ScalarInputDescriptor, AggregationDescriptor, ClassifierDescriptor, MatchNumberDescriptor {
    }

    public static enum NavigationMode {
        RUNNING,
        FINAL;

    }

    public record PatternInputAnalysis(Expression expression, Descriptor descriptor) {
        public PatternInputAnalysis {
            Objects.requireNonNull(expression, "expression is null");
            Objects.requireNonNull(descriptor, "descriptor is null");
        }
    }
}

