/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.gen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.instruction.LabelNode;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.sql.gen.BytecodeGenerator;
import io.trino.sql.gen.BytecodeGeneratorContext;
import io.trino.sql.gen.BytecodeUtils;
import io.trino.sql.gen.RowExpressionCompiler;
import io.trino.sql.relational.Expressions;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.relational.SpecialForm;
import io.trino.sql.relational.VariableReferenceExpression;
import java.util.List;
import java.util.Objects;

public class BetweenCodeGenerator
implements BytecodeGenerator {
    private final RowExpression value;
    private final RowExpression min;
    private final RowExpression max;
    private final ResolvedFunction lessThanOrEqual;

    public BetweenCodeGenerator(SpecialForm specialForm) {
        Objects.requireNonNull(specialForm, "specialForm is null");
        List<RowExpression> arguments = specialForm.arguments();
        Preconditions.checkArgument((arguments.size() == 3 ? 1 : 0) != 0);
        this.value = arguments.get(0);
        this.min = arguments.get(1);
        this.max = arguments.get(2);
        Preconditions.checkArgument((specialForm.functionDependencies().size() == 1 ? 1 : 0) != 0);
        this.lessThanOrEqual = specialForm.getOperatorDependency(OperatorType.LESS_THAN_OR_EQUAL);
    }

    @Override
    public BytecodeNode generateExpression(BytecodeGeneratorContext context) {
        Variable firstValue = context.getScope().getOrCreateTempVariable(this.value.type().getJavaType());
        VariableReferenceExpression valueReference = RowExpressionCompiler.createTempVariableReferenceExpression(firstValue, this.value.type());
        SpecialForm newExpression = new SpecialForm(SpecialForm.Form.AND, (Type)BooleanType.BOOLEAN, (List<RowExpression>)ImmutableList.of((Object)Expressions.call(this.lessThanOrEqual, this.min, valueReference), (Object)Expressions.call(this.lessThanOrEqual, valueReference, this.max)), (List<ResolvedFunction>)ImmutableList.of());
        LabelNode done = new LabelNode("done");
        BytecodeBlock block = new BytecodeBlock().comment("check if value is null").append(context.generate(this.value)).append(BytecodeUtils.ifWasNullPopAndGoto(context.getScope(), done, Boolean.TYPE, this.value.type().getJavaType())).putVariable(firstValue).append(context.generate(newExpression)).visitLabel(done);
        context.getScope().releaseTempVariableForReuse(firstValue);
        return block;
    }
}

