/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.gen.columnar;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.bytecode.Access;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.ClassDefinition;
import io.airlift.bytecode.MethodDefinition;
import io.airlift.bytecode.Parameter;
import io.airlift.bytecode.ParameterizedType;
import io.airlift.bytecode.Scope;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.control.ForLoop;
import io.airlift.bytecode.control.IfStatement;
import io.airlift.bytecode.expression.BytecodeExpression;
import io.airlift.bytecode.expression.BytecodeExpressions;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SourcePage;
import io.trino.spi.function.OperatorType;
import io.trino.sql.gen.CallSiteBinder;
import io.trino.sql.gen.columnar.CallColumnarFilterGenerator;
import io.trino.sql.gen.columnar.ColumnarFilter;
import io.trino.sql.gen.columnar.ColumnarFilterCompiler;
import io.trino.sql.relational.CallExpression;
import io.trino.sql.relational.Expressions;
import io.trino.sql.relational.InputReferenceExpression;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.relational.SpecialForm;
import io.trino.util.CompilerUtils;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

public class BetweenInlineColumnarFilterGenerator {
    private final InputReferenceExpression valueExpression;
    private final CallExpression leftExpression;
    private final CallExpression rightExpression;
    private final FunctionManager functionManager;

    public BetweenInlineColumnarFilterGenerator(SpecialForm specialForm, FunctionManager functionManager) {
        Preconditions.checkArgument((specialForm.form() == SpecialForm.Form.BETWEEN ? 1 : 0) != 0, (Object)"specialForm should be BETWEEN");
        Preconditions.checkArgument((specialForm.arguments().size() == 3 ? 1 : 0) != 0, (String)"BETWEEN should have 3 arguments %s", specialForm.arguments());
        Preconditions.checkArgument((specialForm.functionDependencies().size() == 1 ? 1 : 0) != 0, (String)"BETWEEN should have 1 functional dependency %s", specialForm.functionDependencies());
        this.functionManager = Objects.requireNonNull(functionManager, "functionManager is null");
        Preconditions.checkArgument((boolean)(specialForm.arguments().getFirst() instanceof InputReferenceExpression), (Object)"valueExpression is not an InputReference");
        this.valueExpression = (InputReferenceExpression)specialForm.arguments().get(0);
        ResolvedFunction lessThanOrEqual = specialForm.getOperatorDependency(OperatorType.LESS_THAN_OR_EQUAL);
        this.leftExpression = Expressions.call(lessThanOrEqual, specialForm.arguments().get(1), this.valueExpression);
        this.rightExpression = Expressions.call(lessThanOrEqual, this.valueExpression, specialForm.arguments().get(2));
    }

    public Supplier<ColumnarFilter> generateColumnarFilter() {
        ClassDefinition classDefinition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName(ColumnarFilter.class.getSimpleName() + "_between", Optional.empty()), ParameterizedType.type(Object.class), new ParameterizedType[]{ParameterizedType.type(ColumnarFilter.class)});
        CallSiteBinder callSiteBinder = new CallSiteBinder();
        classDefinition.declareDefaultConstructor(Access.a((Access[])new Access[]{Access.PUBLIC}));
        ColumnarFilterCompiler.generateGetInputChannels(callSiteBinder, classDefinition, this.valueExpression);
        this.generateFilterRangeMethod(callSiteBinder, classDefinition);
        this.generateFilterListMethod(callSiteBinder, classDefinition);
        return ColumnarFilterCompiler.createClassInstance(callSiteBinder, classDefinition);
    }

    private void generateFilterRangeMethod(CallSiteBinder binder, ClassDefinition classDefinition) {
        Parameter session = Parameter.arg((String)"session", ConnectorSession.class);
        Parameter outputPositions = Parameter.arg((String)"outputPositions", int[].class);
        Parameter offset = Parameter.arg((String)"offset", Integer.TYPE);
        Parameter size = Parameter.arg((String)"size", Integer.TYPE);
        Parameter page = Parameter.arg((String)"page", SourcePage.class);
        MethodDefinition method = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "filterPositionsRange", ParameterizedType.type(Integer.TYPE), (Iterable)ImmutableList.of((Object)session, (Object)outputPositions, (Object)offset, (Object)size, (Object)page));
        Scope scope = method.getScope();
        BytecodeBlock body = method.getBody();
        ColumnarFilterCompiler.declareBlockVariables((List<RowExpression>)ImmutableList.of((Object)this.valueExpression), page, scope, body);
        Variable outputPositionsCount = scope.declareVariable("outputPositionsCount", body, BytecodeExpressions.constantInt((int)0));
        Variable position = scope.declareVariable(Integer.TYPE, "position");
        Variable result = scope.declareVariable(Boolean.TYPE, "result");
        IfStatement ifStatement = new IfStatement().condition((BytecodeNode)ColumnarFilterCompiler.generateBlockMayHaveNull((List<RowExpression>)ImmutableList.of((Object)this.valueExpression), scope));
        body.append((BytecodeNode)ifStatement);
        ifStatement.ifTrue((BytecodeNode)new ForLoop("nullable range based loop", new Object[0]).initialize((BytecodeNode)position.set((BytecodeExpression)offset)).condition((BytecodeNode)BytecodeExpressions.lessThan((BytecodeExpression)position, (BytecodeExpression)BytecodeExpressions.add((BytecodeExpression)offset, (BytecodeExpression)size))).update((BytecodeNode)position.increment()).body((BytecodeNode)new IfStatement().condition((BytecodeNode)ColumnarFilterCompiler.generateBlockPositionNotNull((List<RowExpression>)ImmutableList.of((Object)this.valueExpression), scope, position)).ifTrue((BytecodeNode)this.computeAndAssignResult(binder, scope, result, position, outputPositions, outputPositionsCount))));
        ifStatement.ifFalse((BytecodeNode)new ForLoop("non-nullable range based loop", new Object[0]).initialize((BytecodeNode)position.set((BytecodeExpression)offset)).condition((BytecodeNode)BytecodeExpressions.lessThan((BytecodeExpression)position, (BytecodeExpression)BytecodeExpressions.add((BytecodeExpression)offset, (BytecodeExpression)size))).update((BytecodeNode)position.increment()).body((BytecodeNode)this.computeAndAssignResult(binder, scope, result, position, outputPositions, outputPositionsCount)));
        body.append((BytecodeNode)outputPositionsCount.ret());
    }

    private void generateFilterListMethod(CallSiteBinder binder, ClassDefinition classDefinition) {
        Parameter session = Parameter.arg((String)"session", ConnectorSession.class);
        Parameter outputPositions = Parameter.arg((String)"outputPositions", int[].class);
        Parameter activePositions = Parameter.arg((String)"activePositions", int[].class);
        Parameter offset = Parameter.arg((String)"offset", Integer.TYPE);
        Parameter size = Parameter.arg((String)"size", Integer.TYPE);
        Parameter page = Parameter.arg((String)"page", SourcePage.class);
        MethodDefinition method = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "filterPositionsList", ParameterizedType.type(Integer.TYPE), (Iterable)ImmutableList.of((Object)session, (Object)outputPositions, (Object)activePositions, (Object)offset, (Object)size, (Object)page));
        Scope scope = method.getScope();
        BytecodeBlock body = method.getBody();
        ColumnarFilterCompiler.declareBlockVariables((List<RowExpression>)ImmutableList.of((Object)this.valueExpression), page, scope, body);
        Variable outputPositionsCount = scope.declareVariable("outputPositionsCount", body, BytecodeExpressions.constantInt((int)0));
        Variable index = scope.declareVariable(Integer.TYPE, "index");
        Variable position = scope.declareVariable(Integer.TYPE, "position");
        Variable result = scope.declareVariable(Boolean.TYPE, "result");
        IfStatement ifStatement = new IfStatement().condition((BytecodeNode)ColumnarFilterCompiler.generateBlockMayHaveNull((List<RowExpression>)ImmutableList.of((Object)this.valueExpression), scope));
        body.append((BytecodeNode)ifStatement);
        ifStatement.ifTrue((BytecodeNode)new ForLoop("nullable positions loop", new Object[0]).initialize((BytecodeNode)index.set((BytecodeExpression)offset)).condition((BytecodeNode)BytecodeExpressions.lessThan((BytecodeExpression)index, (BytecodeExpression)BytecodeExpressions.add((BytecodeExpression)offset, (BytecodeExpression)size))).update((BytecodeNode)index.increment()).body((BytecodeNode)new BytecodeBlock().append((BytecodeNode)position.set(activePositions.getElement((BytecodeExpression)index))).append((BytecodeNode)new IfStatement().condition((BytecodeNode)ColumnarFilterCompiler.generateBlockPositionNotNull((List<RowExpression>)ImmutableList.of((Object)this.valueExpression), scope, position)).ifTrue((BytecodeNode)this.computeAndAssignResult(binder, scope, result, position, outputPositions, outputPositionsCount)))));
        ifStatement.ifFalse((BytecodeNode)new ForLoop("non-nullable positions loop", new Object[0]).initialize((BytecodeNode)index.set((BytecodeExpression)offset)).condition((BytecodeNode)BytecodeExpressions.lessThan((BytecodeExpression)index, (BytecodeExpression)BytecodeExpressions.add((BytecodeExpression)offset, (BytecodeExpression)size))).update((BytecodeNode)index.increment()).body((BytecodeNode)new BytecodeBlock().append((BytecodeNode)position.set(activePositions.getElement((BytecodeExpression)index))).append((BytecodeNode)this.computeAndAssignResult(binder, scope, result, position, outputPositions, outputPositionsCount))));
        body.append((BytecodeNode)outputPositionsCount.ret());
    }

    private BytecodeBlock computeAndAssignResult(CallSiteBinder binder, Scope scope, Variable result, Variable position, Parameter outputPositions, Variable outputPositionsCount) {
        return new BytecodeBlock().append((BytecodeNode)CallColumnarFilterGenerator.generateInvocation(this.functionManager, binder, this.leftExpression, scope, (BytecodeExpression)position).putVariable(result)).append((BytecodeNode)new IfStatement().condition((BytecodeNode)result).ifTrue((BytecodeNode)CallColumnarFilterGenerator.generateInvocation(this.functionManager, binder, this.rightExpression, scope, (BytecodeExpression)position).putVariable(result))).append((BytecodeNode)ColumnarFilterCompiler.updateOutputPositions(result, position, outputPositions, outputPositionsCount));
    }
}

