/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.gen.columnar;

import com.google.common.base.Verify;
import io.trino.operator.project.InputChannels;
import io.trino.spi.block.Block;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SourcePage;
import io.trino.sql.gen.columnar.ColumnarFilter;

public final class DictionaryAwareColumnarFilter
implements ColumnarFilter {
    private final ColumnarFilter columnarFilter;
    private Block lastInputDictionary;
    private boolean[] lastOutputDictionary;

    public DictionaryAwareColumnarFilter(ColumnarFilter columnarFilter) {
        Verify.verify((columnarFilter.getInputChannels().size() == 1 ? 1 : 0) != 0, (String)"Dictionary aware filtering must have only one input", (Object[])new Object[0]);
        this.columnarFilter = columnarFilter;
    }

    @Override
    public int filterPositionsRange(ConnectorSession session, int[] outputPositions, int offset, int size, SourcePage loadedPage) {
        Block block = loadedPage.getBlock(0);
        if (block instanceof RunLengthEncodedBlock) {
            RunLengthEncodedBlock runLengthEncodedBlock = (RunLengthEncodedBlock)block;
            return this.processRle(session, outputPositions, offset, size, runLengthEncodedBlock);
        }
        if (block instanceof DictionaryBlock) {
            DictionaryBlock dictionaryBlock = (DictionaryBlock)block;
            try {
                return this.processDictionary(session, outputPositions, offset, size, dictionaryBlock);
            }
            catch (Exception ignored) {
                this.lastOutputDictionary = null;
            }
        }
        return this.columnarFilter.filterPositionsRange(session, outputPositions, offset, size, loadedPage);
    }

    @Override
    public int filterPositionsList(ConnectorSession session, int[] outputPositions, int[] activePositions, int offset, int size, SourcePage loadedPage) {
        Block block = loadedPage.getBlock(0);
        if (block instanceof RunLengthEncodedBlock) {
            RunLengthEncodedBlock runLengthEncodedBlock = (RunLengthEncodedBlock)block;
            return this.processRle(session, outputPositions, activePositions, offset, size, runLengthEncodedBlock);
        }
        if (block instanceof DictionaryBlock) {
            DictionaryBlock dictionaryBlock = (DictionaryBlock)block;
            try {
                return this.processDictionary(session, outputPositions, activePositions, offset, size, dictionaryBlock);
            }
            catch (Exception ignored) {
                this.lastOutputDictionary = null;
            }
        }
        return this.columnarFilter.filterPositionsList(session, outputPositions, activePositions, offset, size, loadedPage);
    }

    @Override
    public InputChannels getInputChannels() {
        return this.columnarFilter.getInputChannels();
    }

    private int processRle(ConnectorSession session, int[] outputPositions, int[] activePositions, int offset, int size, RunLengthEncodedBlock runLengthEncodedBlock) {
        ValueBlock value = runLengthEncodedBlock.getValue();
        boolean[] selectedPositionsMask = this.selectedDictionaryMask(session, (Block)value);
        if (!selectedPositionsMask[0]) {
            return 0;
        }
        System.arraycopy(activePositions, offset, outputPositions, 0, size);
        return size;
    }

    private int processRle(ConnectorSession session, int[] outputPositions, int offset, int size, RunLengthEncodedBlock runLengthEncodedBlock) {
        ValueBlock value = runLengthEncodedBlock.getValue();
        boolean[] selectedPositionsMask = this.selectedDictionaryMask(session, (Block)value);
        if (!selectedPositionsMask[0]) {
            return 0;
        }
        for (int index = 0; index < size; ++index) {
            outputPositions[index] = offset + index;
        }
        return size;
    }

    private int processDictionary(ConnectorSession session, int[] outputPositions, int offset, int size, DictionaryBlock dictionaryBlock) {
        boolean[] dictionaryMask = this.selectedDictionaryMask(session, (Block)dictionaryBlock.getDictionary());
        int selectedPositionsCount = 0;
        for (int position = offset; position < offset + size; ++position) {
            outputPositions[selectedPositionsCount] = position;
            selectedPositionsCount += dictionaryMask[dictionaryBlock.getId(position)] ? 1 : 0;
        }
        return selectedPositionsCount;
    }

    private int processDictionary(ConnectorSession session, int[] outputPositions, int[] activePositions, int offset, int size, DictionaryBlock dictionaryBlock) {
        boolean[] dictionaryMask = this.selectedDictionaryMask(session, (Block)dictionaryBlock.getDictionary());
        int selectedPositionsCount = 0;
        for (int index = offset; index < offset + size; ++index) {
            int position;
            outputPositions[selectedPositionsCount] = position = activePositions[index];
            selectedPositionsCount += dictionaryMask[dictionaryBlock.getId(position)] ? 1 : 0;
        }
        return selectedPositionsCount;
    }

    private boolean[] selectedDictionaryMask(ConnectorSession session, Block dictionary) {
        if (this.lastInputDictionary == dictionary) {
            return this.lastOutputDictionary;
        }
        int positionCount = dictionary.getPositionCount();
        int[] selectedPositions = new int[positionCount];
        int selectedPositionsCount = this.columnarFilter.filterPositionsRange(session, selectedPositions, 0, positionCount, SourcePage.create((Block)dictionary));
        boolean[] positionsMask = new boolean[positionCount];
        for (int index = 0; index < selectedPositionsCount; ++index) {
            positionsMask[selectedPositions[index]] = true;
        }
        this.lastInputDictionary = dictionary;
        this.lastOutputDictionary = positionsMask;
        return positionsMask;
    }
}

